/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge;

import gauge.messages.Spec;
import java.util.ArrayList;
import java.util.List;

public class StepValue {
    private final String stepText;
    private final String parameterizedStepText;
    private final List<String> parameters;

    public StepValue(String stepText, String parameterizedStepText, List<String> parameters) {
        this.stepText = stepText;
        this.parameterizedStepText = parameterizedStepText;
        this.parameters = parameters;
    }

    public StepValue(String stepTemplateText, String parameterizedStepText) {
        this.stepText = stepTemplateText;
        this.parameterizedStepText = parameterizedStepText;
        this.parameters = new ArrayList<String>();
    }

    public static StepValue from(Spec.ProtoStepValue protoStepValue) {
        return new StepValue(protoStepValue.getStepValue(), protoStepValue.getParameterizedStepValue(), (List<String>)protoStepValue.getParametersList());
    }

    public String getStepText() {
        return this.stepText;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public int getParamCount() {
        return this.parameters.size();
    }

    public String getStepAnnotationText() {
        return this.parameterizedStepText;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StepValue)) {
            return false;
        }
        StepValue stepValue = (StepValue)o;
        return !((this.parameterizedStepText == null ? stepValue.parameterizedStepText != null : !this.parameterizedStepText.equals(stepValue.parameterizedStepText)) || (this.parameters == null ? stepValue.parameters != null : !this.parameters.equals(stepValue.parameters)) || (this.stepText == null ? stepValue.stepText != null : !this.stepText.equals(stepValue.stepText)));
    }

    public int hashCode() {
        int result = this.stepText != null ? this.stepText.hashCode() : 0;
        result = 31 * result + (this.parameterizedStepText != null ? this.parameterizedStepText.hashCode() : 0);
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "StepValue{stepText='" + this.stepText + '\'' + ", parameterizedStepText='" + this.parameterizedStepText + '\'' + ", parameters=" + this.parameters + '}';
    }
}

