/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.connection;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import com.thoughtworks.gauge.ClassInstanceManager;
import com.thoughtworks.gauge.connection.GaugeConnector;
import com.thoughtworks.gauge.connection.MessageLength;
import com.thoughtworks.gauge.datastore.DataStoreInitializer;
import com.thoughtworks.gauge.execution.parameters.parsers.base.ParameterParsingChain;
import com.thoughtworks.gauge.processor.ExecuteStepProcessor;
import com.thoughtworks.gauge.processor.IMessageProcessor;
import com.thoughtworks.gauge.processor.KillProcessProcessor;
import com.thoughtworks.gauge.processor.RefactorRequestProcessor;
import com.thoughtworks.gauge.processor.ScenarioExecutionEndingProcessor;
import com.thoughtworks.gauge.processor.ScenarioExecutionStartingProcessor;
import com.thoughtworks.gauge.processor.SpecExecutionEndingProcessor;
import com.thoughtworks.gauge.processor.SpecExecutionStartingProcessor;
import com.thoughtworks.gauge.processor.StepExecutionEndingProcessor;
import com.thoughtworks.gauge.processor.StepExecutionStartingProcessor;
import com.thoughtworks.gauge.processor.StepNameRequestProcessor;
import com.thoughtworks.gauge.processor.StepNamesRequestProcessor;
import com.thoughtworks.gauge.processor.SuiteExecutionEndingProcessor;
import com.thoughtworks.gauge.processor.SuiteExecutionStartingProcessor;
import com.thoughtworks.gauge.processor.ValidateStepProcessor;
import com.thoughtworks.gauge.registry.ClassInitializerRegistry;
import com.thoughtworks.gauge.registry.StepRegistry;
import gauge.messages.Messages;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;

public class MessageDispatcher {
    private final HashMap<Messages.Message.MessageType, IMessageProcessor> messageProcessors;

    public MessageDispatcher(final ParameterParsingChain chain, final StepRegistry stepRegistry) {
        final ClassInstanceManager instanceManager = new ClassInstanceManager(ClassInitializerRegistry.classInitializer());
        this.messageProcessors = new HashMap<Messages.Message.MessageType, IMessageProcessor>(){
            {
                this.put(Messages.Message.MessageType.ExecutionStarting, new SuiteExecutionStartingProcessor(instanceManager));
                this.put(Messages.Message.MessageType.ExecutionEnding, new SuiteExecutionEndingProcessor(instanceManager));
                this.put(Messages.Message.MessageType.SpecExecutionStarting, new SpecExecutionStartingProcessor(instanceManager));
                this.put(Messages.Message.MessageType.SpecExecutionEnding, new SpecExecutionEndingProcessor(instanceManager));
                this.put(Messages.Message.MessageType.ScenarioExecutionStarting, new ScenarioExecutionStartingProcessor(instanceManager));
                this.put(Messages.Message.MessageType.ScenarioExecutionEnding, new ScenarioExecutionEndingProcessor(instanceManager));
                this.put(Messages.Message.MessageType.StepExecutionStarting, new StepExecutionStartingProcessor(instanceManager));
                this.put(Messages.Message.MessageType.StepExecutionEnding, new StepExecutionEndingProcessor(instanceManager));
                this.put(Messages.Message.MessageType.ExecuteStep, new ExecuteStepProcessor(instanceManager, chain, stepRegistry));
                this.put(Messages.Message.MessageType.StepValidateRequest, new ValidateStepProcessor(instanceManager, stepRegistry));
                this.put(Messages.Message.MessageType.StepNamesRequest, new StepNamesRequestProcessor(instanceManager, stepRegistry));
                this.put(Messages.Message.MessageType.SuiteDataStoreInit, new DataStoreInitializer(instanceManager));
                this.put(Messages.Message.MessageType.SpecDataStoreInit, new DataStoreInitializer(instanceManager));
                this.put(Messages.Message.MessageType.ScenarioDataStoreInit, new DataStoreInitializer(instanceManager));
                this.put(Messages.Message.MessageType.KillProcessRequest, new KillProcessProcessor(instanceManager));
                this.put(Messages.Message.MessageType.StepNameRequest, new StepNameRequestProcessor(instanceManager, stepRegistry));
                this.put(Messages.Message.MessageType.RefactorRequest, new RefactorRequestProcessor(instanceManager, stepRegistry));
            }
        };
    }

    public void dispatchMessages(GaugeConnector connector) throws IOException {
        Socket gaugeSocket = connector.getGaugeSocket();
        InputStream inputStream = gaugeSocket.getInputStream();
        while (this.isConnected(gaugeSocket)) {
            try {
                MessageLength messageLength = this.getMessageLength(inputStream);
                byte[] bytes = this.toBytes(messageLength);
                Messages.Message message = Messages.Message.parseFrom(bytes);
                if (!this.messageProcessors.containsKey((Object)message.getMessageType())) {
                    System.err.println("Invalid message type received " + (Object)((Object)message.getMessageType()));
                    continue;
                }
                IMessageProcessor messageProcessor = this.messageProcessors.get((Object)message.getMessageType());
                Messages.Message response = messageProcessor.process(message);
                this.writeMessage(gaugeSocket, response);
                if (message.getMessageType() != Messages.Message.MessageType.KillProcessRequest) continue;
                gaugeSocket.close();
                return;
            }
            catch (InvalidProtocolBufferException e) {
                return;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                System.err.println(throwable.toString());
                return;
            }
        }
    }

    private MessageLength getMessageLength(InputStream is) throws IOException {
        CodedInputStream codedInputStream = CodedInputStream.newInstance((InputStream)is);
        long size = codedInputStream.readRawVarint64();
        return new MessageLength(size, codedInputStream);
    }

    private byte[] toBytes(MessageLength messageLength) throws IOException {
        long messageSize = messageLength.getLength();
        CodedInputStream stream = messageLength.getRemainingStream();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int i = 0;
        while ((long)i < messageSize) {
            outputStream.write(stream.readRawByte());
            ++i;
        }
        return outputStream.toByteArray();
    }

    private void writeMessage(Socket socket, Messages.Message message) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        CodedOutputStream cos = CodedOutputStream.newInstance((OutputStream)stream);
        byte[] bytes = message.toByteArray();
        cos.writeRawVarint64((long)bytes.length);
        cos.flush();
        stream.write(bytes);
        socket.getOutputStream().write(stream.toByteArray());
        socket.getOutputStream().flush();
    }

    private boolean isConnected(Socket socket) {
        return !socket.isClosed() && socket.isConnected();
    }
}

