/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.execution.parameters.parsers.base;

import com.google.common.base.Predicate;
import com.thoughtworks.gauge.ClasspathHelper;
import com.thoughtworks.gauge.execution.parameters.ParsingException;
import com.thoughtworks.gauge.execution.parameters.parsers.base.CustomParameterParser;
import com.thoughtworks.gauge.execution.parameters.parsers.base.ParameterParser;
import com.thoughtworks.gauge.execution.parameters.parsers.converters.TableConverter;
import com.thoughtworks.gauge.execution.parameters.parsers.types.EnumParameterParser;
import com.thoughtworks.gauge.execution.parameters.parsers.types.PrimitiveParameterParser;
import com.thoughtworks.gauge.execution.parameters.parsers.types.PrimitivesConverter;
import com.thoughtworks.gauge.execution.parameters.parsers.types.TableParameterParser;
import gauge.messages.Spec;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public class ParameterParsingChain
implements ParameterParser {
    private List<ParameterParser> chain = new LinkedList<ParameterParser>();

    public ParameterParsingChain() {
        this.createReflections().getSubTypesOf(CustomParameterParser.class).stream().map(this::asCustomParameterParser).filter(Objects::nonNull).forEach(this.chain::add);
        this.chain.add(new TableParameterParser(new TableConverter()));
        this.chain.add(new EnumParameterParser());
        this.chain.add(new PrimitiveParameterParser(new PrimitivesConverter()));
    }

    private Reflections createReflections() {
        ConfigurationBuilder config = new ConfigurationBuilder().setScanners(new Scanner[]{new SubTypesScanner()}).addUrls(ClasspathHelper.getUrls()).filterInputsBy((Predicate)new FilterBuilder().include(".+\\.class"));
        return new Reflections((Configuration)config);
    }

    @Nullable
    private ParameterParser asCustomParameterParser(Class<? extends ParameterParser> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    @Override
    public boolean canParse(Class<?> parameterType, Spec.Parameter parameter) {
        return true;
    }

    @Override
    public Object parse(Class<?> parameterType, Spec.Parameter parameter) throws ParsingException {
        for (ParameterParser parser : this.chain) {
            if (!parser.canParse(parameterType, parameter)) continue;
            return parser.parse(parameterType, parameter);
        }
        return parameter.getValue();
    }
}

