/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.processor;

import com.thoughtworks.gauge.ClassInstanceManager;
import com.thoughtworks.gauge.StepValue;
import com.thoughtworks.gauge.processor.IMessageProcessor;
import com.thoughtworks.gauge.refactor.JavaRefactoring;
import com.thoughtworks.gauge.refactor.RefactoringResult;
import com.thoughtworks.gauge.registry.StepRegistry;
import gauge.messages.Messages;
import java.util.List;

public class RefactorRequestProcessor
implements IMessageProcessor {
    private final StepRegistry registry;

    public RefactorRequestProcessor(ClassInstanceManager instanceManager, StepRegistry registry) {
        this.registry = registry;
    }

    @Override
    public Messages.Message process(Messages.Message message) {
        Messages.RefactorRequest refactorRequest = message.getRefactorRequest();
        StepValue oldStepValue = StepValue.from(refactorRequest.getOldStepValue());
        StepValue newStepValue = StepValue.from(refactorRequest.getNewStepValue());
        List<Messages.ParameterPosition> paramPositions = refactorRequest.getParamPositionsList();
        RefactoringResult result = new JavaRefactoring(oldStepValue, newStepValue, paramPositions, this.registry).performRefactoring();
        return this.createRefactorResponse(message, result);
    }

    private Messages.Message createRefactorResponse(Messages.Message message, RefactoringResult result) {
        return Messages.Message.newBuilder().setMessageId(message.getMessageId()).setMessageType(Messages.Message.MessageType.RefactorResponse).setRefactorResponse(Messages.RefactorResponse.newBuilder().setSuccess(result.passed()).setError(result.errorMessage()).addFilesChanged(result.fileChanged()).build()).build();
    }
}

