/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.processor;

import com.thoughtworks.gauge.ClassInstanceManager;
import com.thoughtworks.gauge.processor.IMessageProcessor;
import com.thoughtworks.gauge.registry.StepRegistry;
import gauge.messages.Messages;
import java.util.Set;

public class StepNameRequestProcessor
implements IMessageProcessor {
    private final StepRegistry registry;

    public StepNameRequestProcessor(ClassInstanceManager instanceManager, StepRegistry registry) {
        this.registry = registry;
    }

    @Override
    public Messages.Message process(Messages.Message message) {
        Set<String> stepAnnotations = this.registry.getAllAliasAnnotationTextsFor(message.getStepNameRequest().getStepValue());
        boolean hasAlias = false;
        boolean isStepPresent = false;
        if (stepAnnotations.size() > 1) {
            hasAlias = true;
        }
        if (stepAnnotations.size() >= 1) {
            isStepPresent = true;
        }
        return Messages.Message.newBuilder().setMessageId(message.getMessageId()).setMessageType(Messages.Message.MessageType.StepNameResponse).setStepNameResponse(Messages.StepNameResponse.newBuilder().addAllStepName(stepAnnotations).setIsStepPresent(isStepPresent).setHasAlias(hasAlias).build()).build();
    }
}

