/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.refactor;

import com.github.javaparser.ast.CompilationUnit;
import com.thoughtworks.gauge.StepValue;
import com.thoughtworks.gauge.refactor.FileModifier;
import com.thoughtworks.gauge.refactor.JavaParseWorker;
import com.thoughtworks.gauge.refactor.JavaRefactoringElement;
import com.thoughtworks.gauge.refactor.RefactoringException;
import com.thoughtworks.gauge.refactor.RefactoringMethodVisitor;
import com.thoughtworks.gauge.refactor.RefactoringResult;
import com.thoughtworks.gauge.refactor.Util;
import com.thoughtworks.gauge.registry.StepRegistry;
import gauge.messages.Messages;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class JavaRefactoring {
    private final StepValue oldStepValue;
    private final StepValue newStepValue;
    private final List<Messages.ParameterPosition> paramPositions;
    private StepRegistry registry;

    public JavaRefactoring(StepValue oldStepValue, StepValue newStepValue, List<Messages.ParameterPosition> paramPositionsList, StepRegistry registry) {
        this.oldStepValue = oldStepValue;
        this.newStepValue = newStepValue;
        this.paramPositions = paramPositionsList;
        this.registry = registry;
    }

    public RefactoringResult performRefactoring() {
        JavaRefactoringElement element;
        String oldStepText = this.oldStepValue.getStepText();
        String fileName = this.registry.getFileName(oldStepText);
        if (fileName == null || fileName.isEmpty()) {
            return new RefactoringResult(false, "Step Implementation Not Found: Unable to find a file Name to refactor");
        }
        if (this.registry.hasAlias(oldStepText)) {
            return new RefactoringResult(false, "Refactoring for steps having aliases are not supported.");
        }
        if (this.registry.getAll(oldStepText).size() > 1) {
            return new RefactoringResult(false, "Duplicate step implementation found.");
        }
        try {
            element = this.createJavaRefactoringElement(fileName);
            new FileModifier(element).refactor();
        }
        catch (IOException e) {
            return new RefactoringResult(false, "Unable to read/write file while refactoring. " + e.getMessage());
        }
        catch (RefactoringException e) {
            return new RefactoringResult(false, "Step Implementation Not Found: " + e.getMessage());
        }
        catch (Exception e) {
            return new RefactoringResult(false, "Refactoring failed: " + e.getMessage());
        }
        return new RefactoringResult(true, "", element.getFile().getAbsolutePath());
    }

    JavaRefactoringElement createJavaRefactoringElement(String fileName) throws RefactoringException {
        List<JavaParseWorker> javaParseWorkers = this.parseJavaFiles(Util.workingDir(), fileName);
        if (javaParseWorkers.isEmpty()) {
            throw new RefactoringException("Unable to find file: " + fileName);
        }
        try {
            for (JavaParseWorker javaFile : javaParseWorkers) {
                CompilationUnit compilationUnit = javaFile.getCompilationUnit();
                RefactoringMethodVisitor methodVisitor = new RefactoringMethodVisitor(this.oldStepValue, this.newStepValue, this.paramPositions);
                methodVisitor.visit(compilationUnit, null);
                if (!methodVisitor.refactored()) continue;
                JavaRefactoringElement javaElement = methodVisitor.getRefactoredJavaElement();
                javaElement.setFile(javaFile.getJavaFile());
                return javaElement;
            }
        }
        catch (Exception e) {
            throw new RefactoringException("Failed creating java element: " + e.getMessage());
        }
        throw new RefactoringException("Unable to find implementation");
    }

    private List<JavaParseWorker> parseJavaFiles(File workingDir, String fileName) {
        File[] allFiles;
        ArrayList<JavaParseWorker> javaFiles = new ArrayList<JavaParseWorker>();
        for (File file : allFiles = workingDir.listFiles()) {
            if (file.isDirectory()) {
                javaFiles.addAll(this.parseJavaFiles(file, fileName));
                continue;
            }
            if (!file.getAbsolutePath().endsWith(fileName)) continue;
            JavaParseWorker worker = new JavaParseWorker(file);
            worker.start();
            javaFiles.add(worker);
        }
        return javaFiles;
    }
}

