/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.refactor;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclaratorId;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import com.thoughtworks.gauge.StepValue;
import com.thoughtworks.gauge.refactor.JavaRefactoringElement;
import com.thoughtworks.gauge.refactor.Util;
import gauge.messages.Messages;
import java.util.Arrays;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.lang.StringEscapeUtils;

public class RefactoringMethodVisitor
extends VoidVisitorAdapter {
    private StepValue oldStepValue;
    private StepValue newStepValue;
    private List<Messages.ParameterPosition> paramPositions;
    private boolean refactored;
    private JavaRefactoringElement javaElement;

    public RefactoringMethodVisitor(StepValue oldStepValue, StepValue newStepValue, List<Messages.ParameterPosition> paramPositions) {
        this.oldStepValue = oldStepValue;
        this.newStepValue = newStepValue;
        this.paramPositions = paramPositions;
    }

    public void visit(MethodDeclaration methodDeclaration, Object arg) {
        try {
            List annotations = methodDeclaration.getAnnotations();
            if (annotations == null) {
                return;
            }
            for (AnnotationExpr annotationExpr : annotations) {
                StringLiteralExpr memberValue;
                if (!(annotationExpr instanceof SingleMemberAnnotationExpr)) continue;
                SingleMemberAnnotationExpr annotation = (SingleMemberAnnotationExpr)annotationExpr;
                if (annotation.getMemberValue() instanceof BinaryExpr) {
                    ScriptEngine engine = new ScriptEngineManager().getEngineByName("JavaScript");
                    try {
                        Object result = engine.eval(annotation.getMemberValue().toString());
                        this.refactor(methodDeclaration, new StringLiteralExpr(result.toString()), annotation);
                    }
                    catch (ScriptException e) {
                        continue;
                    }
                }
                if (annotation.getMemberValue() instanceof StringLiteralExpr) {
                    memberValue = (StringLiteralExpr)annotation.getMemberValue();
                    this.refactor(methodDeclaration, memberValue, annotation);
                }
                if (!(annotation.getMemberValue() instanceof ArrayInitializerExpr) || (memberValue = (ArrayInitializerExpr)annotation.getMemberValue()).getValues().size() != 1) continue;
                StringLiteralExpr expression = (StringLiteralExpr)memberValue.getValues().get(0);
                this.refactor(methodDeclaration, expression, annotation);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void refactor(MethodDeclaration methodDeclaration, StringLiteralExpr memberValue, SingleMemberAnnotationExpr annotation) {
        if (StringEscapeUtils.unescapeJava((String)memberValue.getValue()).trim().equals(this.oldStepValue.getStepAnnotationText().trim())) {
            List<Parameter> newParameters = Arrays.asList(new Parameter[this.paramPositions.size()]);
            memberValue.setValue(StringEscapeUtils.escapeJava((String)this.newStepValue.getStepAnnotationText()));
            List parameters = methodDeclaration.getParameters();
            int paramPositionsSize = this.paramPositions.size();
            for (int i = 0; i < paramPositionsSize; ++i) {
                if (this.paramPositions.get(i).getOldPosition() < 0) {
                    String paramName = Util.getValidJavaIdentifier(Util.convertToCamelCase("arg " + this.newStepValue.getParameters().get(i)));
                    if (paramName.equals("arg")) {
                        paramName = paramName + i;
                    }
                    newParameters.set(this.paramPositions.get(i).getNewPosition(), new Parameter((Type)new ClassOrInterfaceType("Object"), new VariableDeclaratorId(paramName)));
                    continue;
                }
                newParameters.set(this.paramPositions.get(i).getNewPosition(), (Parameter)parameters.get(this.paramPositions.get(i).getOldPosition()));
            }
            for (int k = 0; k < newParameters.size(); ++k) {
                for (int l = k + 1; l < newParameters.size(); ++l) {
                    if (!newParameters.get(k).getName().equals(newParameters.get(l).getName())) continue;
                    newParameters.set(l, new Parameter((Type)new ClassOrInterfaceType("Object"), new VariableDeclaratorId(newParameters.get(l).getName() + l)));
                }
            }
            methodDeclaration.setParameters(newParameters);
            annotation.setMemberValue((Expression)memberValue);
            this.javaElement = new JavaRefactoringElement(this.getJavaFileText(methodDeclaration), null);
            this.refactored = true;
        }
    }

    private String getJavaFileText(MethodDeclaration methodDeclaration) {
        return this.getFileElement((Node)methodDeclaration).toString();
    }

    private Node getFileElement(Node node) {
        if (node instanceof CompilationUnit) {
            return node;
        }
        return this.getFileElement(node.getParentNode());
    }

    public boolean refactored() {
        return this.refactored;
    }

    public JavaRefactoringElement getRefactoredJavaElement() {
        return this.javaElement;
    }
}

