/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.registry;

import com.thoughtworks.gauge.StepValue;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class StepRegistry {
    private HashMap<String, Set<StepRegistryEntry>> registry = new HashMap();

    public void addStepImplementation(StepValue stepValue, Method method) {
        String stepText = stepValue.getStepText();
        this.registry.putIfAbsent(stepText, new HashSet());
        this.registry.get(stepText).add(new StepRegistryEntry(stepValue, method));
    }

    public boolean contains(String stepTemplateText) {
        return this.registry.containsKey(stepTemplateText);
    }

    public Method get(String stepTemplateText) {
        return this.getFirstEntry(stepTemplateText).getMethod();
    }

    private StepRegistryEntry getFirstEntry(String stepTemplateText) {
        return ((Set)this.registry.getOrDefault(stepTemplateText, new HashSet())).stream().findFirst().orElse(new StepRegistryEntry());
    }

    public String getFileName(String stepTemplateText) {
        return this.getFirstEntry(stepTemplateText).getFileName();
    }

    public List<String> getAllStepAnnotationTexts() {
        return this.registry.values().stream().flatMap(Collection::stream).map(entry -> entry.getStepValue().getStepAnnotationText()).collect(Collectors.toList());
    }

    private List<String> getStepAnnotationFor(Set<String> stepTexts) {
        ArrayList<String> annotations = new ArrayList<String>();
        for (String stepText : stepTexts) {
            annotations.add(this.getStepAnnotationFor(stepText));
        }
        return annotations;
    }

    String getStepAnnotationFor(String stepTemplateText) {
        return this.registry.values().stream().flatMap(Collection::stream).map(StepRegistryEntry::getStepValue).filter(stepValue -> stepValue.getStepText().equals(stepTemplateText)).map(StepValue::getStepAnnotationText).findFirst().orElse("");
    }

    public Set<String> getAllAliasAnnotationTextsFor(String stepTemplateText) {
        Method method = this.get(stepTemplateText);
        return this.registry.values().stream().flatMap(Collection::stream).filter(registryEntry -> registryEntry.getMethod().equals(method)).map(registryEntry -> registryEntry.getStepValue().getStepAnnotationText()).collect(Collectors.toSet());
    }

    public boolean hasAlias(String stepTemplateText) {
        return this.getStepAnnotationFor(this.getAllAliasAnnotationTextsFor(stepTemplateText)).size() > 1;
    }

    void remove(String stepTemplateText) {
        this.registry.remove(stepTemplateText);
    }

    public Set<Method> getAll(String stepText) {
        return ((Set)this.registry.getOrDefault(stepText, new HashSet())).stream().map(StepRegistryEntry::getMethod).collect(Collectors.toSet());
    }

    private class StepRegistryEntry {
        private final StepValue stepValue;
        private final Method method;

        StepRegistryEntry(StepValue stepValue, Method method) {
            this.stepValue = stepValue;
            this.method = method;
        }

        StepRegistryEntry() {
            this.stepValue = new StepValue("", "", new ArrayList<String>());
            this.method = null;
        }

        public StepValue getStepValue() {
            return this.stepValue;
        }

        public Method getMethod() {
            return this.method;
        }

        public String getFileName() {
            if (this.method == null) {
                return "";
            }
            return this.method.getDeclaringClass().getCanonicalName().replace(".", File.separator) + ".java";
        }
    }
}

