/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.scan;

import com.thoughtworks.gauge.Step;
import com.thoughtworks.gauge.StepValue;
import com.thoughtworks.gauge.connection.GaugeConnector;
import com.thoughtworks.gauge.registry.StepRegistry;
import com.thoughtworks.gauge.scan.IScanner;
import java.lang.reflect.Method;
import java.util.Set;
import org.reflections.Reflections;

public class StepsScanner
implements IScanner {
    private GaugeConnector connector;
    private StepRegistry registry;

    public StepsScanner(GaugeConnector connector, StepRegistry registry) {
        this.connector = connector;
        this.registry = registry;
    }

    @Override
    public void scan(Reflections reflections) {
        Set stepImplementations = reflections.getMethodsAnnotatedWith(Step.class);
        this.buildStepRegistry(stepImplementations);
    }

    private void buildStepRegistry(Set<Method> stepImplementations) {
        for (Method method : stepImplementations) {
            Step annotation = method.getAnnotation(Step.class);
            if (annotation == null) continue;
            for (String stepName : annotation.value()) {
                StepValue stepValue = this.connector.getGaugeApiConnection().getStepValue(stepName);
                this.registry.addStepImplementation(stepValue, method);
            }
        }
    }
}

