/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge;

import com.thoughtworks.gauge.LspServer;
import com.thoughtworks.gauge.connection.GaugeConnector;
import com.thoughtworks.gauge.connection.MessageDispatcher;
import com.thoughtworks.gauge.scan.StaticScanner;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GaugeRuntime {
    private static List<Thread> threads = new ArrayList<Thread>();

    public static void main(String[] args) throws Exception {
        StaticScanner staticScanner = new StaticScanner();
        staticScanner.addStepsToRegistry();
        MessageDispatcher messageDispatcher = new MessageDispatcher(staticScanner);
        if (System.getenv("GAUGE_LSP_GRPC") != null) {
            GaugeRuntime.startGRPCServer(messageDispatcher);
        } else {
            GaugeRuntime.startGaugeServer(messageDispatcher);
        }
        for (Thread thread : threads) {
            thread.join();
        }
        System.exit(0);
    }

    private static void startGaugeServer(MessageDispatcher messageDispatcher) {
        int apiPort = GaugeRuntime.readEnvVar("GAUGE_API_PORT");
        String portInfo = System.getenv("GAUGE_API_PORTS");
        if (portInfo != null && !portInfo.trim().isEmpty()) {
            List<String> ports = Arrays.asList(portInfo.split(","));
            int portsSize = ports.size();
            for (int i = 0; i < portsSize; ++i) {
                if (i == 0) {
                    GaugeRuntime.connectSynchronously(Integer.parseInt(ports.get(i)), apiPort, messageDispatcher);
                    continue;
                }
                GaugeRuntime.connectInParallel(Integer.parseInt(ports.get(i)), apiPort, messageDispatcher);
            }
        } else {
            GaugeRuntime.connectSynchronously(GaugeRuntime.readEnvVar("GAUGE_INTERNAL_PORT"), apiPort, messageDispatcher);
        }
    }

    private static void startGRPCServer(MessageDispatcher messageDispatcher) throws IOException, InterruptedException {
        LspServer lspServer = new LspServer(messageDispatcher);
        Server server = ServerBuilder.forPort((int)0).addService((BindableService)lspServer).build();
        lspServer.addServer(server);
        server.start();
        int port = server.getPort();
        System.out.println("Listening on port:" + port);
        server.awaitTermination();
    }

    private static int readEnvVar(String env) {
        String port = System.getenv(env);
        if (port == null || port.equalsIgnoreCase("")) {
            throw new RuntimeException(env + " not set");
        }
        return Integer.parseInt(port);
    }

    private static void connectInParallel(int gaugeInternalPort, int gaugeApiPort, MessageDispatcher messageDispatcher) {
        Thread thread = new Thread(() -> GaugeRuntime.dispatchMessages(messageDispatcher, GaugeRuntime.makeConnection(gaugeInternalPort, gaugeApiPort)));
        GaugeRuntime.startThread(thread);
    }

    private static void connectSynchronously(int gaugeInternalPort, int gaugeApiPort, MessageDispatcher messageDispatcher) {
        GaugeConnector connector = GaugeRuntime.makeConnection(gaugeInternalPort, gaugeApiPort);
        Thread thread = new Thread(() -> GaugeRuntime.dispatchMessages(messageDispatcher, connector));
        GaugeRuntime.startThread(thread);
    }

    private static void startThread(Thread thread) {
        threads.add(thread);
        thread.start();
    }

    private static GaugeConnector makeConnection(int gaugeInternalPort, int gaugeApiPort) {
        GaugeConnector connector = new GaugeConnector();
        connector.makeConnectionsToGaugeCore(gaugeInternalPort, gaugeApiPort);
        return connector;
    }

    private static void dispatchMessages(MessageDispatcher messageDispatcher, GaugeConnector connector) {
        try {
            messageDispatcher.dispatchMessages(connector);
        }
        catch (IOException e) {
            Thread t = Thread.currentThread();
            t.getUncaughtExceptionHandler().uncaughtException(t, e);
        }
    }
}

