/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.registry;

import com.thoughtworks.gauge.StepRegistryEntry;
import com.thoughtworks.gauge.StepValue;
import gauge.messages.Messages;
import gauge.messages.Spec;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

public class StepRegistry {
    private HashMap<String, CopyOnWriteArrayList<StepRegistryEntry>> registry = new HashMap();

    public void addStepImplementation(StepValue stepValue, Method method) {
        String stepText = stepValue.getStepText();
        this.registry.putIfAbsent(stepText, new CopyOnWriteArrayList());
        this.registry.get(stepText).add(new StepRegistryEntry(stepValue, method));
    }

    public boolean contains(String stepTemplateText) {
        return this.registry.containsKey(stepTemplateText);
    }

    public StepRegistryEntry get(String stepTemplateText) {
        return this.getFirstEntry(stepTemplateText);
    }

    private StepRegistryEntry getFirstEntry(String stepTemplateText) {
        return this.registry.getOrDefault(stepTemplateText, new CopyOnWriteArrayList()).stream().findFirst().orElse(new StepRegistryEntry());
    }

    public List<String> getAllStepAnnotationTexts() {
        return this.registry.values().stream().flatMap(Collection::stream).map(entry -> entry.getStepValue().getStepAnnotationText()).collect(Collectors.toList());
    }

    String getStepAnnotationFor(String stepTemplateText) {
        return this.registry.values().stream().flatMap(Collection::stream).map(StepRegistryEntry::getStepValue).filter(stepValue -> stepValue.getStepText().equals(stepTemplateText)).map(StepValue::getStepAnnotationText).findFirst().orElse("");
    }

    public void remove(String stepTemplateText) {
        this.registry.remove(stepTemplateText);
    }

    List<StepRegistryEntry> getAllEntries(String stepText) {
        return this.registry.get(stepText);
    }

    public void removeSteps(String fileName) {
        HashMap<String, CopyOnWriteArrayList> newRegistry = new HashMap<String, CopyOnWriteArrayList>();
        for (String key : this.registry.keySet()) {
            CopyOnWriteArrayList newEntryList = this.registry.get(key).stream().filter(entry -> !entry.getFileName().equals(fileName)).collect(Collectors.toCollection(CopyOnWriteArrayList::new));
            if (newEntryList.size() <= 0) continue;
            newRegistry.put(key, newEntryList);
        }
        this.registry = newRegistry;
    }

    public void addStep(StepValue stepValue, StepRegistryEntry entry) {
        String stepText = stepValue.getStepText();
        this.registry.putIfAbsent(stepText, new CopyOnWriteArrayList());
        this.registry.get(stepText).add(entry);
    }

    public boolean hasMultipleImplementations(String stepToValidate) {
        return this.getAllEntries(stepToValidate).size() > 1;
    }

    public List<Messages.StepPositionsResponse.StepPosition> getStepPositions(String filePath) {
        ArrayList<Messages.StepPositionsResponse.StepPosition> stepPositionsList = new ArrayList<Messages.StepPositionsResponse.StepPosition>();
        for (Map.Entry<String, CopyOnWriteArrayList<StepRegistryEntry>> entryList : this.registry.entrySet()) {
            for (StepRegistryEntry entry : entryList.getValue()) {
                if (!entry.getFileName().equals(filePath)) continue;
                Messages.StepPositionsResponse.StepPosition stepPosition = Messages.StepPositionsResponse.StepPosition.newBuilder().setStepValue(entryList.getKey()).setSpan(Spec.Span.newBuilder().setStart(entry.getSpan().begin.line).setStartChar(entry.getSpan().begin.column).setEnd(entry.getSpan().end.line).setEndChar(entry.getSpan().end.column).build()).build();
                stepPositionsList.add(stepPosition);
            }
        }
        return stepPositionsList;
    }

    public boolean isFileCached(String fileName) {
        for (String key : this.registry.keySet()) {
            if (!this.registry.get(key).stream().anyMatch(entry -> entry.getFileName().equals(fileName))) continue;
            return true;
        }
        return false;
    }
}

