/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.scan;

import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import com.thoughtworks.gauge.StepRegistryEntry;
import com.thoughtworks.gauge.StepValue;
import com.thoughtworks.gauge.registry.StepRegistry;
import java.util.ArrayList;
import java.util.List;

public class RegistryMethodVisitor
extends VoidVisitorAdapter {
    private StepValue stepValue;
    private StepRegistryEntry entry;
    private StepRegistry stepRegistry;
    private String file;

    public RegistryMethodVisitor(StepRegistry stepRegistry, String file) {
        this.stepRegistry = stepRegistry;
        this.file = file;
    }

    public void visit(MethodDeclaration methodDeclaration, Object arg) {
        List annotations = methodDeclaration.getAnnotations();
        if (annotations.isEmpty()) {
            return;
        }
        for (AnnotationExpr annotationExpr : annotations) {
            if (!(annotationExpr instanceof SingleMemberAnnotationExpr)) continue;
            SingleMemberAnnotationExpr annotation = (SingleMemberAnnotationExpr)annotationExpr;
            if (annotation.getMemberValue() instanceof ArrayInitializerExpr) {
                ArrayInitializerExpr memberValue = (ArrayInitializerExpr)annotation.getMemberValue();
                for (Expression expression : memberValue.getValues()) {
                    this.addStepToRegistry(expression, methodDeclaration, annotation);
                }
                continue;
            }
            this.addStepToRegistry(annotation.getMemberValue(), methodDeclaration, annotation);
        }
    }

    private void addStepToRegistry(Expression expression, MethodDeclaration methodDeclaration, SingleMemberAnnotationExpr annotation) {
        String parameterizedStep = expression.toString().replaceAll("\"", "");
        String stepText = this.getStepText(parameterizedStep);
        this.stepValue = new StepValue(stepText, parameterizedStep);
        this.entry = new StepRegistryEntry();
        this.entry.setName(methodDeclaration.getDeclarationAsString());
        this.entry.setStepText(parameterizedStep);
        this.entry.setStepValue(this.stepValue);
        this.entry.setParameters(methodDeclaration.getParameters());
        this.entry.setSpan(methodDeclaration.getRange());
        this.entry.setHasAlias(this.hasAlias(annotation));
        this.entry.setAliases(this.getAliases(annotation));
        this.entry.setFileName(this.file);
        this.stepRegistry.addStep(this.stepValue, this.entry);
    }

    private String getStepText(String parameterizedStepText) {
        return parameterizedStepText.replaceAll("(<.*?>)", "{}");
    }

    private Boolean hasAlias(SingleMemberAnnotationExpr annotation) {
        return annotation.getMemberValue() instanceof ArrayInitializerExpr;
    }

    private List<String> getAliases(SingleMemberAnnotationExpr annotation) {
        ArrayList<String> aliases = new ArrayList<String>();
        if (annotation.getMemberValue() instanceof ArrayInitializerExpr) {
            ArrayInitializerExpr memberValue = (ArrayInitializerExpr)annotation.getMemberValue();
            for (Expression expression : memberValue.getValues()) {
                aliases.add(expression.toString().replaceAll("\"", ""));
            }
        }
        return aliases;
    }
}

