/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.processor;

import com.github.javaparser.Range;
import com.thoughtworks.gauge.StepRegistryEntry;
import com.thoughtworks.gauge.processor.IMessageProcessor;
import com.thoughtworks.gauge.registry.StepRegistry;
import gauge.messages.Messages;
import gauge.messages.Spec;
import java.util.List;

public class StepNameRequestProcessor
implements IMessageProcessor {
    private final StepRegistry registry;

    public StepNameRequestProcessor(StepRegistry registry) {
        this.registry = registry;
    }

    @Override
    public Messages.Message process(Messages.Message message) {
        boolean hasAlias;
        boolean isStepPresent = this.registry.contains(message.getStepNameRequest().getStepValue());
        if (!isStepPresent) {
            return Messages.Message.newBuilder().setMessageId(message.getMessageId()).setMessageType(Messages.Message.MessageType.StepNameResponse).setStepNameResponse(Messages.StepNameResponse.newBuilder().setIsStepPresent(false).build()).build();
        }
        StepRegistryEntry entry = this.registry.get(message.getStepNameRequest().getStepValue());
        List<String> stepTexts = entry.getAliases();
        Range range = entry.getSpan();
        String fileName = "";
        Spec.Span.Builder spanBuilder = Spec.Span.newBuilder();
        if (System.getenv("GAUGE_LSP_GRPC") != null) {
            String stepText = entry.getStepText();
            fileName = entry.getFileName();
            hasAlias = entry.getHasAlias();
            if (!hasAlias) {
                stepTexts.add(stepText);
            }
            spanBuilder = Spec.Span.newBuilder().setStart(range.begin.line).setStartChar(range.begin.column).setEnd(range.end.line).setEndChar(range.end.column);
        } else {
            stepTexts = this.registry.getAllAliasAnnotationTextsFor(message.getStepNameRequest().getStepValue());
            hasAlias = stepTexts.size() > 1;
        }
        return Messages.Message.newBuilder().setMessageId(message.getMessageId()).setMessageType(Messages.Message.MessageType.StepNameResponse).setStepNameResponse(Messages.StepNameResponse.newBuilder().addAllStepName(stepTexts).setIsStepPresent(true).setHasAlias(hasAlias).setFileName(fileName).setSpan(spanBuilder).build()).build();
    }
}

