/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.scan;

import com.thoughtworks.gauge.ClassInitializer;
import com.thoughtworks.gauge.DefaultClassInitializer;
import com.thoughtworks.gauge.registry.ClassInitializerRegistry;
import com.thoughtworks.gauge.scan.IScanner;
import java.util.Set;
import org.reflections.Reflections;

public class CustomClassInitializerScanner
implements IScanner {
    @Override
    public void scan(Reflections reflections) {
        this.scanForInitializer(reflections);
    }

    private void scanForInitializer(Reflections reflections) {
        Set initializers = reflections.getSubTypesOf(ClassInitializer.class);
        initializers.remove(DefaultClassInitializer.class);
        if (initializers.size() == 1) {
            Class initializer = (Class)initializers.iterator().next();
            try {
                ClassInitializerRegistry.classInitializer((ClassInitializer)initializer.newInstance());
                System.out.println(String.format("Using %s as class initializer", initializer.getName()));
            }
            catch (InstantiationException e) {
                System.err.println(String.format("Could not instantiate %s, continuing using default class initializer", initializer.getName()));
            }
            catch (IllegalAccessException e) {
                System.err.println(String.format("Could not access %s constructor, continuing using default class initializer", initializer.getName()));
            }
        }
        if (initializers.size() > 1) {
            System.out.println("[Warning] Multiple class initializers found, switching to default.");
        }
    }
}

