/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge;

import com.thoughtworks.gauge.ClassInstanceManager;
import com.thoughtworks.gauge.Gauge;
import com.thoughtworks.gauge.Logger;
import com.thoughtworks.gauge.LspServer;
import com.thoughtworks.gauge.connection.GaugeConnector;
import com.thoughtworks.gauge.connection.MessageDispatcher;
import com.thoughtworks.gauge.registry.ClassInitializerRegistry;
import com.thoughtworks.gauge.scan.ClasspathScanner;
import com.thoughtworks.gauge.scan.CustomClassInitializerScanner;
import com.thoughtworks.gauge.scan.HooksScanner;
import com.thoughtworks.gauge.scan.StaticScanner;
import com.thoughtworks.gauge.scan.StepsScanner;
import com.thoughtworks.gauge.screenshot.CustomScreenshotScanner;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class GaugeRuntime {
    private static List<Thread> threads = new ArrayList<Thread>();

    public static void main(String[] args) throws Exception {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> Logger.fatal("Error in thread " + t.getId(), e));
        StaticScanner staticScanner = new StaticScanner();
        if (System.getenv("GAUGE_LSP_GRPC") != null) {
            staticScanner.addStepsToRegistry();
            GaugeRuntime.startGRPCServer(staticScanner);
        } else {
            GaugeRuntime.startGaugeServer(staticScanner);
            for (Thread thread : threads) {
                thread.join();
            }
        }
        System.exit(0);
    }

    private static void startGaugeServer(StaticScanner staticScanner) {
        String portInfo = System.getenv("GAUGE_API_PORTS");
        if (portInfo != null && !portInfo.trim().isEmpty()) {
            List<String> ports = Arrays.asList(portInfo.split(","));
            Logger.debug(String.format("Connecting to port(s): %s", portInfo));
            int portsSize = ports.size();
            for (int i = 0; i < portsSize; ++i) {
                if (i == 0) {
                    GaugeRuntime.connectSynchronously(Integer.parseInt(ports.get(i)), staticScanner);
                    continue;
                }
                GaugeRuntime.connectInParallel(Integer.parseInt(ports.get(i)), staticScanner);
            }
        } else {
            int gaugeInternalPort = GaugeRuntime.readEnvVar("GAUGE_INTERNAL_PORT");
            Logger.debug(String.format("Connecting to port: %d", gaugeInternalPort));
            GaugeRuntime.connectSynchronously(gaugeInternalPort, staticScanner);
        }
    }

    private static void startGRPCServer(StaticScanner staticScanner) throws IOException, InterruptedException {
        MessageDispatcher messageDispatcher = new MessageDispatcher(staticScanner, new ClassInstanceManager(ClassInitializerRegistry.classInitializer()));
        LspServer lspServer = new LspServer(messageDispatcher);
        Server server = ServerBuilder.forPort((int)0).addService((BindableService)lspServer).executor((Executor)Executors.newFixedThreadPool(1)).build();
        lspServer.addServer(server);
        server.start();
        int port = server.getPort();
        Logger.info("Listening on port:" + port);
        server.awaitTermination();
    }

    private static int readEnvVar(String env) {
        String port = System.getenv(env);
        if (port == null || port.equalsIgnoreCase("")) {
            throw new RuntimeException(env + " not set");
        }
        return Integer.parseInt(port);
    }

    private static void connectInParallel(int gaugeInternalPort, StaticScanner staticScanner) {
        Thread thread = new Thread(() -> GaugeRuntime.dispatchMessages(staticScanner, GaugeRuntime.makeConnection(gaugeInternalPort)));
        GaugeRuntime.startThread(thread);
    }

    private static void connectSynchronously(int gaugeInternalPort, StaticScanner staticScanner) {
        GaugeConnector connector = GaugeRuntime.makeConnection(gaugeInternalPort);
        ClasspathScanner classpathScanner = new ClasspathScanner();
        classpathScanner.scan(new StepsScanner(staticScanner.getRegistry()), new HooksScanner(), new CustomScreenshotScanner(), new CustomClassInitializerScanner());
        Thread thread = new Thread(() -> GaugeRuntime.dispatchMessages(staticScanner, connector));
        GaugeRuntime.startThread(thread);
    }

    private static void startThread(Thread thread) {
        threads.add(thread);
        thread.start();
    }

    private static GaugeConnector makeConnection(int gaugeInternalPort) {
        GaugeConnector connector = new GaugeConnector();
        connector.makeConnectionsToGaugeCore(gaugeInternalPort);
        return connector;
    }

    private static void dispatchMessages(StaticScanner staticScanner, GaugeConnector connector) {
        try {
            ClassInstanceManager instanceManager = new ClassInstanceManager(ClassInitializerRegistry.classInitializer());
            Gauge.setInstanceManager(instanceManager);
            MessageDispatcher messageDispatcher = new MessageDispatcher(staticScanner, instanceManager);
            messageDispatcher.dispatchMessages(connector);
        }
        catch (IOException e) {
            Thread t = Thread.currentThread();
            t.getUncaughtExceptionHandler().uncaughtException(t, e);
        }
    }
}

