/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge;

import com.thoughtworks.gauge.FileHelper;
import com.thoughtworks.gauge.connection.MessageDispatcher;
import com.thoughtworks.gauge.processor.IMessageProcessor;
import gauge.messages.Lsp;
import gauge.messages.Messages;
import gauge.messages.lspServiceGrpc;
import io.grpc.Server;
import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.stream.Collectors;

public class LspServer
extends lspServiceGrpc.lspServiceImplBase {
    private MessageDispatcher messageDispatcher;
    private Server server;

    LspServer(MessageDispatcher messageDispatcher) {
        this.messageDispatcher = messageDispatcher;
    }

    void addServer(Server lspServer) {
        this.server = lspServer;
    }

    @Override
    public void getStepNames(final Messages.StepNamesRequest request, StreamObserver<Messages.StepNamesResponse> responseObserver) {
        IMessageProcessor processor = this.messageDispatcher.getProcessor(Messages.Message.MessageType.StepNamesRequest);
        Messages.Message process = processor.process(new Messages.Message(){

            @Override
            public Messages.StepNamesRequest getStepNamesRequest() {
                return request;
            }
        });
        responseObserver.onNext((Object)process.getStepNamesResponse());
        responseObserver.onCompleted();
    }

    @Override
    public void cacheFile(final Messages.CacheFileRequest request, StreamObserver<Lsp.Empty> responseObserver) {
        IMessageProcessor processor = this.messageDispatcher.getProcessor(Messages.Message.MessageType.CacheFileRequest);
        processor.process(new Messages.Message(){

            @Override
            public Messages.CacheFileRequest getCacheFileRequest() {
                return request;
            }
        });
        responseObserver.onNext((Object)Lsp.Empty.newBuilder().build());
        responseObserver.onCompleted();
    }

    @Override
    public void getStepPositions(final Messages.StepPositionsRequest request, StreamObserver<Messages.StepPositionsResponse> responseObserver) {
        IMessageProcessor processor = this.messageDispatcher.getProcessor(Messages.Message.MessageType.StepPositionsRequest);
        Messages.Message process = processor.process(new Messages.Message(){

            @Override
            public Messages.StepPositionsRequest getStepPositionsRequest() {
                return request;
            }
        });
        responseObserver.onNext((Object)process.getStepPositionsResponse());
        responseObserver.onCompleted();
    }

    @Override
    public void getImplementationFiles(Lsp.Empty request, StreamObserver<Messages.ImplementationFileListResponse> responseObserver) {
        List<String> allImplFiles = FileHelper.getAllImplementationFiles();
        responseObserver.onNext((Object)Messages.ImplementationFileListResponse.newBuilder().addAllImplementationFilePaths(allImplFiles).build());
        responseObserver.onCompleted();
    }

    @Override
    public void implementStub(final Messages.StubImplementationCodeRequest request, StreamObserver<Messages.FileDiff> responseObserver) {
        IMessageProcessor processor = this.messageDispatcher.getProcessor(Messages.Message.MessageType.StubImplementationCodeRequest);
        Messages.Message process = processor.process(new Messages.Message(){

            @Override
            public Messages.StubImplementationCodeRequest getStubImplementationCodeRequest() {
                return request;
            }
        });
        responseObserver.onNext((Object)process.getFileDiff());
        responseObserver.onCompleted();
    }

    @Override
    public void validateStep(final Messages.StepValidateRequest request, StreamObserver<Messages.StepValidateResponse> responseObserver) {
        IMessageProcessor processor = this.messageDispatcher.getProcessor(Messages.Message.MessageType.StepValidateRequest);
        Messages.Message process = processor.process(new Messages.Message(){

            @Override
            public Messages.StepValidateRequest getStepValidateRequest() {
                return request;
            }
        });
        responseObserver.onNext((Object)process.getStepValidateResponse());
        responseObserver.onCompleted();
    }

    @Override
    public void refactor(final Messages.RefactorRequest request, StreamObserver<Messages.RefactorResponse> responseObserver) {
        IMessageProcessor processor = this.messageDispatcher.getProcessor(Messages.Message.MessageType.RefactorRequest);
        Messages.Message process = processor.process(new Messages.Message(){

            @Override
            public Messages.RefactorRequest getRefactorRequest() {
                return request;
            }
        });
        responseObserver.onNext((Object)process.getRefactorResponse());
        responseObserver.onCompleted();
    }

    @Override
    public void getStepName(final Messages.StepNameRequest request, StreamObserver<Messages.StepNameResponse> responseObserver) {
        IMessageProcessor processor = this.messageDispatcher.getProcessor(Messages.Message.MessageType.StepNameRequest);
        Messages.Message process = processor.process(new Messages.Message(){

            @Override
            public Messages.StepNameRequest getStepNameRequest() {
                return request;
            }
        });
        responseObserver.onNext((Object)process.getStepNameResponse());
        responseObserver.onCompleted();
    }

    @Override
    public void getGlobPatterns(Lsp.Empty request, StreamObserver<Messages.ImplementationFileGlobPatternResponse> responseObserver) {
        List<String> patterns = FileHelper.getStepImplDirs().stream().map(dir -> dir + "/**/*.java").collect(Collectors.toList());
        responseObserver.onNext((Object)Messages.ImplementationFileGlobPatternResponse.newBuilder().addAllGlobPatterns(patterns).build());
        responseObserver.onCompleted();
    }

    @Override
    public void killProcess(Messages.KillProcessRequest request, StreamObserver<Lsp.Empty> responseObserver) {
        responseObserver.onNext((Object)Lsp.Empty.newBuilder().build());
        responseObserver.onCompleted();
        this.server.shutdownNow();
    }
}

