/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.connection;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ProtocolStringList;
import com.thoughtworks.gauge.ConceptInfo;
import com.thoughtworks.gauge.PluginNotInstalledException;
import com.thoughtworks.gauge.StepValue;
import com.thoughtworks.gauge.connection.MessageLength;
import gauge.messages.Api;
import gauge.messages.Spec;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class GaugeConnection {
    private static final int GET_STEP_MSG_ID = 2;
    private static final int GET_INSTALLATION_ROOT_MSG_ID = 3;
    private static final int GET_STEP_VALUE_MSG_ID = 4;
    private static final int GET_LIB_PATH_MSG_ID = 5;
    private static final int GET_CONCEPT_MSG_ID = 6;
    private static final int PERFORM_REFACTORING_MSG_ID = 7;
    private static final int EXTRACT_CONCEPT_MSG_ID = 8;
    private final int port;
    private Socket gaugeSocket;

    public GaugeConnection(int port) {
        this.port = port;
        this.createConnection(10);
    }

    public GaugeConnection(Socket socket) {
        this.gaugeSocket = socket;
        this.port = socket.getPort();
    }

    private static MessageLength getMessageLength(InputStream is) throws IOException {
        CodedInputStream codedInputStream = CodedInputStream.newInstance((InputStream)is);
        long size = codedInputStream.readRawVarint64();
        return new MessageLength(size, codedInputStream);
    }

    private static byte[] toBytes(MessageLength messageLength) throws IOException {
        long messageSize = messageLength.getLength();
        CodedInputStream stream = messageLength.getRemainingStream();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int i = 0;
        while ((long)i < messageSize) {
            outputStream.write(stream.readRawByte());
            ++i;
        }
        return outputStream.toByteArray();
    }

    private void createConnection(int tries) {
        try {
            this.gaugeSocket = new Socket("127.0.0.1", this.port);
        }
        catch (IOException e) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            if (tries == 0) {
                RuntimeException re = new RuntimeException("Gauge API not started : " + e);
                re.setStackTrace(e.getStackTrace());
                throw re;
            }
            this.createConnection(tries - 1);
        }
    }

    public List<StepValue> fetchAllSteps() throws IOException {
        Api.APIMessage message = this.getStepRequest();
        Api.APIMessage response = this.getAPIResponse(message);
        Api.GetAllStepsResponse allStepsResponse = response.getAllStepsResponse();
        ArrayList<StepValue> steps = new ArrayList<StepValue>();
        for (Spec.ProtoStepValue stepValueResponse : allStepsResponse.getAllStepsList()) {
            StepValue stepValue = new StepValue(stepValueResponse.getStepValue(), stepValueResponse.getParameterizedStepValue(), (List<String>)stepValueResponse.getParametersList());
            steps.add(stepValue);
        }
        return steps;
    }

    public List<ConceptInfo> fetchAllConcepts() throws IOException {
        Api.APIMessage message = this.getConceptRequest();
        Api.APIMessage response = this.getAPIResponse(message);
        Api.GetAllConceptsResponse allConceptsResponse = response.getAllConceptsResponse();
        ArrayList<ConceptInfo> conceptsInfo = new ArrayList<ConceptInfo>();
        for (Api.ConceptInfo conceptInfoResponse : allConceptsResponse.getConceptsList()) {
            Spec.ProtoStepValue protoStepValue = conceptInfoResponse.getStepValue();
            StepValue stepValue = new StepValue(protoStepValue.getStepValue(), protoStepValue.getParameterizedStepValue(), (List<String>)protoStepValue.getParametersList());
            ConceptInfo conceptInfo = new ConceptInfo(stepValue, conceptInfoResponse.getFilepath(), conceptInfoResponse.getLineNumber());
            conceptsInfo.add(conceptInfo);
        }
        return conceptsInfo;
    }

    public String getLibPath(String language) throws IOException, PluginNotInstalledException {
        Api.APIMessage message = this.getLibPathRequest(language);
        Api.APIMessage response = this.getAPIResponse(message);
        if (response.getMessageType().equals((Object)Api.APIMessage.APIMessageType.ErrorResponse)) {
            throw new PluginNotInstalledException(response.getError().getError());
        }
        return response.getLibPathResponse().getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Api.APIMessage getAPIResponse(Api.APIMessage message) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        CodedOutputStream cos = CodedOutputStream.newInstance((OutputStream)stream);
        byte[] bytes = message.toByteArray();
        cos.writeRawVarint64((long)bytes.length);
        cos.flush();
        stream.write(bytes);
        Socket socket = this.gaugeSocket;
        synchronized (socket) {
            this.gaugeSocket.getOutputStream().write(stream.toByteArray());
            this.gaugeSocket.getOutputStream().flush();
            InputStream remoteStream = this.gaugeSocket.getInputStream();
            MessageLength messageLength = GaugeConnection.getMessageLength(remoteStream);
            bytes = GaugeConnection.toBytes(messageLength);
        }
        Api.APIMessage apiMessage = Api.APIMessage.parseFrom(bytes);
        return apiMessage;
    }

    public File getInstallationRoot() throws IOException {
        Api.APIMessage installationRootRequest = this.getInstallationRootRequest();
        Api.APIMessage response = this.getAPIResponse(installationRootRequest);
        Api.GetInstallationRootResponse allStepsResponse = response.getInstallationRootResponse();
        File installationRoot = new File(allStepsResponse.getInstallationRoot());
        if (installationRoot.exists()) {
            return installationRoot;
        }
        throw new IOException(installationRoot + " does not exist");
    }

    public StepValue getStepValue(String stepText) {
        return this.getStepValue(stepText, false);
    }

    public StepValue getStepValue(String stepText, boolean hasInlineTable) {
        Api.APIMessage response;
        Api.APIMessage stepValueRequest = this.getStepValueRequest(stepText, hasInlineTable);
        try {
            response = this.getAPIResponse(stepValueRequest);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        Api.GetStepValueResponse stepValueResponse = response.getStepValueResponse();
        Spec.ProtoStepValue protoStepValue = stepValueResponse.getStepValue();
        String stepValue = protoStepValue.getStepValue();
        ProtocolStringList parametersList = protoStepValue.getParametersList();
        String parameterizedStepValue = protoStepValue.getParameterizedStepValue();
        return new StepValue(stepValue, parameterizedStepValue, (List<String>)parametersList);
    }

    public boolean isConnected() {
        return this.gaugeSocket.isConnected();
    }

    public void close() throws IOException {
        this.gaugeSocket.close();
    }

    public Api.PerformRefactoringResponse sendPerformRefactoringRequest(String oldName, String newName) throws Exception {
        Api.APIMessage refactoringRequest = this.createPerformRefactoringRequest(oldName, newName);
        Api.APIMessage response = this.getAPIResponse(refactoringRequest);
        return response.getPerformRefactoringResponse();
    }

    public Api.ExtractConceptResponse sendGetExtractConceptRequest(List<Api.step> steps, Api.step concept, boolean changeAcrossProject, String fileName, Api.textInfo selectedTextInfo) throws Exception {
        Api.APIMessage request = this.createExtractConceptRequest(steps, concept, changeAcrossProject, fileName, selectedTextInfo);
        Api.APIMessage response = this.getAPIResponse(request);
        return response.getExtractConceptResponse();
    }

    private Api.APIMessage getStepRequest() {
        Api.GetAllStepsRequest stepRequest = Api.GetAllStepsRequest.newBuilder().build();
        return Api.APIMessage.newBuilder().setMessageType(Api.APIMessage.APIMessageType.GetAllStepsRequest).setMessageId(2L).setAllStepsRequest(stepRequest).build();
    }

    private Api.APIMessage getInstallationRootRequest() {
        Api.GetInstallationRootRequest installationRootRequest = Api.GetInstallationRootRequest.newBuilder().build();
        return Api.APIMessage.newBuilder().setMessageType(Api.APIMessage.APIMessageType.GetInstallationRootRequest).setMessageId(3L).setInstallationRootRequest(installationRootRequest).build();
    }

    private Api.APIMessage getStepValueRequest(String stepText, boolean hasInlineTable) {
        Api.GetStepValueRequest stepValueRequest = Api.GetStepValueRequest.newBuilder().setStepText(stepText).setHasInlineTable(hasInlineTable).build();
        return Api.APIMessage.newBuilder().setMessageType(Api.APIMessage.APIMessageType.GetStepValueRequest).setMessageId(4L).setStepValueRequest(stepValueRequest).build();
    }

    private Api.APIMessage getLibPathRequest(String language) {
        Api.GetLanguagePluginLibPathRequest libPathRequest = Api.GetLanguagePluginLibPathRequest.newBuilder().setLanguage(language).build();
        return Api.APIMessage.newBuilder().setMessageType(Api.APIMessage.APIMessageType.GetLanguagePluginLibPathRequest).setMessageId(5L).setLibPathRequest(libPathRequest).build();
    }

    private Api.APIMessage getConceptRequest() {
        Api.GetAllConceptsRequest conceptRequest = Api.GetAllConceptsRequest.newBuilder().build();
        return Api.APIMessage.newBuilder().setMessageType(Api.APIMessage.APIMessageType.GetAllConceptsRequest).setMessageId(6L).setAllConceptsRequest(conceptRequest).build();
    }

    private Api.APIMessage createPerformRefactoringRequest(String oldName, String newName) {
        Api.PerformRefactoringRequest performRefactoringRequest = Api.PerformRefactoringRequest.newBuilder().setOldStep(oldName).setNewStep(newName).build();
        return Api.APIMessage.newBuilder().setMessageType(Api.APIMessage.APIMessageType.PerformRefactoringRequest).setMessageId(7L).setPerformRefactoringRequest(performRefactoringRequest).build();
    }

    private Api.APIMessage createExtractConceptRequest(List<Api.step> steps, Api.step concept, boolean changeAcrossProject, String fileName, Api.textInfo selectedTextInfo) {
        Api.ExtractConceptRequest request = Api.ExtractConceptRequest.newBuilder().addAllSteps(steps).setChangeAcrossProject(changeAcrossProject).setSelectedTextInfo(selectedTextInfo).setConceptFileName(fileName).setConceptName(concept).build();
        return Api.APIMessage.newBuilder().setMessageType(Api.APIMessage.APIMessageType.ExtractConceptRequest).setMessageId(8L).setExtractConceptRequest(request).build();
    }
}

