/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.connection;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseException;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import com.google.protobuf.ProtocolStringList;
import com.thoughtworks.gauge.FileHelper;
import com.thoughtworks.gauge.Logger;
import com.thoughtworks.gauge.processor.IMessageProcessor;
import gauge.messages.Messages;
import gauge.messages.Spec;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class StubImplementationCodeProcessor
implements IMessageProcessor {
    private static final String NEW_LINE = "\n";
    private static ArrayList<MethodDeclaration> methodDeclarations = new ArrayList();

    @Override
    public Messages.Message process(Messages.Message message) {
        Messages.FileDiff fileDiff;
        ProtocolStringList stubs = message.getStubImplementationCodeRequest().getCodesList();
        String filePath = message.getStubImplementationCodeRequest().getImplementationFilePath();
        File file = new File(filePath);
        if (file.exists()) {
            fileDiff = this.implementInExistingFile(stubs, file);
        } else {
            File fileName = FileHelper.getDefaultImplFileName("", 0);
            fileDiff = this.implementInNewClass(stubs, fileName);
        }
        return Messages.Message.newBuilder().setMessageId(message.getMessageId()).setFileDiff(fileDiff).setMessageType(Messages.Message.MessageType.StubImplementationCodeRequest).build();
    }

    private Messages.FileDiff implementInExistingFile(ProtocolStringList stubs, File file) {
        try {
            if (new FileReader(file).read() != -1) {
                return this.implementInExistingClass(stubs, file);
            }
            return this.implementInNewClass(stubs, file);
        }
        catch (IOException e) {
            Logger.error("Unable to implement method", e);
            return null;
        }
    }

    private Messages.FileDiff implementInNewClass(ProtocolStringList stubs, File file) {
        String className = FileHelper.getClassName(file);
        String contents = this.getNewClassContents(className, stubs);
        Spec.Span.Builder span = Spec.Span.newBuilder().setStart(0L).setStartChar(0L).setEnd(0L).setEndChar(0L);
        Messages.TextDiff textDiff = Messages.TextDiff.newBuilder().setSpan(span).setContent(contents).build();
        return Messages.FileDiff.newBuilder().setFilePath(file.toString()).addTextDiffs(textDiff).build();
    }

    private String getNewClassContents(String className, ProtocolStringList stubs) {
        return "import com.thoughtworks.gauge.Step;\n\npublic class " + className + " {" + NEW_LINE + String.join((CharSequence)NEW_LINE, (Iterable<? extends CharSequence>)stubs) + NEW_LINE + "}" + NEW_LINE;
    }

    private Messages.FileDiff implementInExistingClass(ProtocolStringList stubs, File file) {
        try {
            CompilationUnit compilationUnit = JavaParser.parse((File)file);
            MethodVisitor methodVisitor = new MethodVisitor();
            methodVisitor.visit(compilationUnit, null);
            MethodDeclaration methodDeclaration = methodDeclarations.get(methodDeclarations.size() - 1);
            int lastLine = methodDeclaration.getRange().end.line - 1;
            int column = methodDeclaration.getRange().end.column + 1;
            String contents = NEW_LINE + String.join((CharSequence)NEW_LINE, (Iterable<? extends CharSequence>)stubs);
            Spec.Span.Builder span = Spec.Span.newBuilder().setStart(lastLine).setStartChar(column).setEnd(lastLine).setEndChar(column);
            Messages.TextDiff textDiff = Messages.TextDiff.newBuilder().setSpan(span).setContent(contents).build();
            return Messages.FileDiff.newBuilder().setFilePath(file.toString()).addTextDiffs(textDiff).build();
        }
        catch (ParseException | IOException e) {
            Logger.error("Unable to implement method", e);
            return null;
        }
    }

    private class MethodVisitor
    extends VoidVisitorAdapter {
        private MethodVisitor() {
        }

        public void visit(MethodDeclaration methodDeclaration, Object arg) {
            methodDeclarations.add(methodDeclaration);
        }
    }
}

