/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.execution.parameters;

import gauge.messages.Spec;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public final class DynamicParametersReplacer {
    private static final Pattern REPLACER_PATTERN = Pattern.compile("<(.*?)>");

    private DynamicParametersReplacer() {
    }

    public static String replacePlaceholders(String stepText, List<Spec.Parameter> parameters) {
        if (StringUtils.isEmpty((String)stepText) || parameters == null || parameters.isEmpty()) {
            return stepText;
        }
        for (Spec.Parameter parameter : parameters) {
            if (parameter.getParameterType() != Spec.Parameter.ParameterType.Dynamic) continue;
            stepText = DynamicParametersReplacer.findAndReplacePlaceholder(stepText, parameter.getValue());
        }
        return stepText;
    }

    private static String findAndReplacePlaceholder(String stepText, String parameterValue) {
        Matcher matcher = REPLACER_PATTERN.matcher(stepText);
        if (matcher.find()) {
            return matcher.replaceFirst(Matcher.quoteReplacement("\"" + parameterValue + "\""));
        }
        return stepText;
    }
}

