/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.scan;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseException;
import com.github.javaparser.ast.CompilationUnit;
import com.google.common.base.Charsets;
import com.thoughtworks.gauge.FileHelper;
import com.thoughtworks.gauge.Logger;
import com.thoughtworks.gauge.Step;
import com.thoughtworks.gauge.StepRegistryEntry;
import com.thoughtworks.gauge.StepValue;
import com.thoughtworks.gauge.registry.StepRegistry;
import com.thoughtworks.gauge.scan.ClasspathScanner;
import com.thoughtworks.gauge.scan.RegistryMethodVisitor;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;

public class StaticScanner {
    private StepRegistry stepRegistry = new StepRegistry();

    public StepRegistry getRegistry() {
        return this.stepRegistry;
    }

    public void reloadSteps(String fileName, String contents) {
        this.removeSteps(fileName);
        this.addStepsFromFileContents(fileName, contents);
    }

    public void addStepsFromFileContents(String file, String contents) {
        try {
            StringReader reader = new StringReader(contents);
            CompilationUnit compilationUnit = JavaParser.parse((Reader)reader);
            RegistryMethodVisitor methodVisitor = new RegistryMethodVisitor(this.stepRegistry, file);
            methodVisitor.visit(compilationUnit, null);
        }
        catch (ParseException e) {
            Logger.error(String.format("Exception while adding steps from %s file:", file));
            Logger.error(String.format("%s\n%s", e.getMessage(), e.getStackTrace()));
        }
    }

    public void removeSteps(String fileName) {
        this.stepRegistry.removeSteps(fileName);
    }

    public void addStepsToRegistry() {
        List<String> files = FileHelper.getAllImplementationFiles();
        for (String file : files) {
            String contents = this.readFile(file, Charsets.UTF_8);
            this.addStepsFromFileContents(file, contents);
        }
    }

    public StepRegistry getStepRegistry(ClasspathScanner classpathScanner) {
        Set<Method> methods = classpathScanner.getAllMethods();
        for (Method method : methods) {
            Step annotation = method.getAnnotation(Step.class);
            if (annotation == null) continue;
            for (String stepName : annotation.value()) {
                String stepText = stepName.replaceAll("(<.*?>)", "{}");
                StepValue stepValue = new StepValue(stepText, stepName);
                StepRegistryEntry entry = this.stepRegistry.get(stepText);
                entry.setMethodInfo(method);
                this.stepRegistry.addStep(stepValue, entry);
            }
        }
        return this.stepRegistry;
    }

    public boolean isFileCached(String fileName) {
        return this.stepRegistry.isFileCached(fileName);
    }

    public String readFile(String path, Charset encoding) {
        try {
            byte[] contents = Files.readAllBytes(Paths.get(path, new String[0]));
            return new String(contents, encoding);
        }
        catch (IOException e) {
            Logger.error("Unable to read file", e);
            return null;
        }
    }
}

