/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.screenshot;

import com.thoughtworks.gauge.ClassInstanceManager;
import com.thoughtworks.gauge.Logger;
import com.thoughtworks.gauge.screenshot.ICustomScreenshotGrabber;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;

public class ScreenshotFactory {
    public static final String IMAGE_EXTENSION = "png";
    private static Class<? extends ICustomScreenshotGrabber> customScreenshotGrabber;
    private static ClassInstanceManager manager;

    public ScreenshotFactory(ClassInstanceManager manager) {
        ScreenshotFactory.manager = manager;
    }

    static void setCustomScreenshotGrabber(Class<? extends ICustomScreenshotGrabber> customScreenGrabber) {
        customScreenshotGrabber = customScreenGrabber;
    }

    public byte[] getScreenshotBytes() {
        if (this.shouldTakeScreenshot()) {
            return this.takeScreenshot();
        }
        return new byte[0];
    }

    private byte[] takeScreenshot() {
        if (customScreenshotGrabber != null) {
            try {
                ICustomScreenshotGrabber customScreenGrabberInstance = (ICustomScreenshotGrabber)manager.get(customScreenshotGrabber);
                byte[] bytes = customScreenGrabberInstance.takeScreenshot();
                if (bytes == null) {
                    bytes = new byte[]{};
                }
                return bytes;
            }
            catch (Exception e) {
                Logger.error(String.format("Failed to take Custom screenshot: %s : %s", customScreenshotGrabber.getCanonicalName(), e.getMessage()));
                Logger.warning("Capturing regular screenshot..");
            }
        }
        return this.captureScreen();
    }

    private byte[] captureScreen() {
        ByteArrayOutputStream imageBytes = new ByteArrayOutputStream();
        if (this.shouldTakeScreenshot()) {
            try {
                Rectangle screenRect = new Rectangle(0, 0, 0, 0);
                for (GraphicsDevice gd : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                    screenRect = screenRect.union(gd.getDefaultConfiguration().getBounds());
                }
                BufferedImage image = new Robot().createScreenCapture(screenRect);
                ImageIO.write((RenderedImage)image, IMAGE_EXTENSION, imageBytes);
            }
            catch (Throwable e) {
                Logger.error("Failed to take regular screenshot: " + e.getMessage());
                return new byte[0];
            }
        }
        return imageBytes.toByteArray();
    }

    private boolean shouldTakeScreenshot() {
        String screenshotEnabled = System.getenv("screenshot_on_failure");
        return screenshotEnabled != null && !screenshotEnabled.toLowerCase().equals("false");
    }
}

