/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.command;

import com.thoughtworks.gauge.Logger;
import com.thoughtworks.gauge.RunnerServiceHandler;
import com.thoughtworks.gauge.command.GaugeJavaCommand;
import com.thoughtworks.gauge.connection.MessageProcessorFactory;
import com.thoughtworks.gauge.scan.StaticScanner;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;

public class StartCommand
implements GaugeJavaCommand {
    @Override
    public void execute() throws Exception {
        StaticScanner staticScanner = new StaticScanner();
        staticScanner.addStepsToRegistry();
        boolean multithreading = false;
        int stream = 1;
        String streamValue = System.getenv("GAUGE_PARALLEL_STREAMS_COUNT");
        if (streamValue != null && !streamValue.isEmpty()) {
            stream = Integer.parseInt(streamValue);
            multithreading = true;
        }
        MessageProcessorFactory messageProcessorFactory = new MessageProcessorFactory(staticScanner);
        RunnerServiceHandler runnerServiceHandler = new RunnerServiceHandler(messageProcessorFactory, multithreading, stream);
        Server server = ServerBuilder.forPort((int)0).addService((BindableService)runnerServiceHandler).executor(Runnable::run).build();
        runnerServiceHandler.addServer(server);
        server.start();
        int port = server.getPort();
        Logger.info("Listening on port:" + port);
        server.awaitTermination();
        System.exit(0);
    }
}

