/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.scan;

import com.thoughtworks.gauge.Logger;
import com.thoughtworks.gauge.Step;
import com.thoughtworks.gauge.StepRegistryEntry;
import com.thoughtworks.gauge.StepValue;
import com.thoughtworks.gauge.Util;
import com.thoughtworks.gauge.registry.StepRegistry;
import com.thoughtworks.gauge.scan.IScanner;
import com.thoughtworks.gauge.scan.StepsUtil;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.reflections.Reflections;

public class StepsScanner
implements IScanner {
    private StepRegistry registry;

    public StepsScanner(StepRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void scan(Reflections reflections) {
        Logger.debug("Scanning packages for steps");
        Set stepImplementations = reflections.getMethodsAnnotatedWith(Step.class);
        this.buildStepRegistry(stepImplementations);
    }

    private void buildStepRegistry(Set<Method> stepImplementations) {
        StepsUtil stepsUtil = new StepsUtil();
        for (Method method : stepImplementations) {
            Step annotation = method.getAnnotation(Step.class);
            if (annotation == null) continue;
            for (String stepName : annotation.value()) {
                String parameterizedStep = Util.trimQuotes(stepName);
                String stepText = stepsUtil.getStepText(parameterizedStep);
                if (this.registry.contains(stepText)) {
                    StepRegistryEntry entry = this.registry.getForCurrentProject(stepText, method);
                    if (entry != null) {
                        Logger.debug("Found " + stepText + " in current project scope.");
                        entry.setMethodInfo(method);
                        continue;
                    }
                    this.addExternalStepEntryToRegistry(stepsUtil, method, parameterizedStep, stepText);
                    continue;
                }
                this.addExternalStepEntryToRegistry(stepsUtil, method, parameterizedStep, stepText);
            }
        }
    }

    private void addExternalStepEntryToRegistry(StepsUtil stepsUtil, Method method, String parameterizedStep, String stepText) {
        Logger.debug("Loading " + stepText + "via reflected sources.");
        List<String> parameters = stepsUtil.getParameters(parameterizedStep);
        StepValue stepValue = new StepValue(stepText, parameterizedStep, parameters);
        this.registry.addStepImplementation(stepValue, method, true);
    }
}

