/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge;

import com.thoughtworks.gauge.ClassInstanceManager;
import com.thoughtworks.gauge.screenshot.ScreenshotFactory;
import java.util.ArrayList;
import java.util.List;

public class Gauge {
    private static ThreadLocal<List<String>> messages = new InheritableThreadLocal<List<String>>(){

        @Override
        protected List<String> initialValue() {
            return new ArrayList<String>();
        }
    };
    private static ClassInstanceManager instanceManager;
    private static ThreadLocal<List<String>> screenshots;

    public static void setInstanceManager(ClassInstanceManager instanceManager) {
        Gauge.instanceManager = instanceManager;
    }

    public static void writeMessage(String message) {
        Gauge.getMessages().add(message);
    }

    public static void writeMessage(String format, String ... args) {
        Gauge.getMessages().add(String.format(format, args));
    }

    static List<String> getMessages() {
        return messages.get();
    }

    public static void captureScreenshot() {
        String screenshotFileName = new ScreenshotFactory(instanceManager).getScreenshotBytes();
        Gauge.getScreenshots().add(screenshotFileName);
    }

    static List<String> getScreenshots() {
        return screenshots.get();
    }

    static {
        screenshots = new InheritableThreadLocal<List<String>>(){

            @Override
            protected List<String> initialValue() {
                return new ArrayList<String>();
            }
        };
    }
}

