/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge;

import com.thoughtworks.gauge.GaugeConstant;
import com.thoughtworks.gauge.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public class FileHelper {
    private static final String CUSTOM_COMPILE_DIR_SEPARATOR = ",";
    private static final String JAVA_FILE_EXT = ".java";

    public static List<String> getAllImplementationFiles() {
        ArrayList<String> outputFiles = new ArrayList<String>();
        FileHelper.getStepImplDirs().forEach(dir -> {
            try (Stream<Path> filePathStream = Files.walk(Path.of(dir, new String[0]), new FileVisitOption[0]);){
                filePathStream.forEach(filePath -> {
                    if (Files.isRegularFile(filePath, new LinkOption[0]) && filePath.toString().endsWith(JAVA_FILE_EXT)) {
                        outputFiles.add(filePath.toString());
                    }
                });
            }
            catch (IOException e) {
                Logger.error("", e);
            }
        });
        return outputFiles;
    }

    private static Path getAbsolutePath(String dir) {
        Path path = Path.of(dir, new String[0]);
        return !path.isAbsolute() ? Path.of(System.getenv("GAUGE_PROJECT_ROOT"), dir) : path;
    }

    static List<String> getStepImplDirs() {
        ArrayList<String> srcDirs = new ArrayList<String>();
        String customCompileDirs = System.getenv("gauge_custom_compile_dir");
        if (customCompileDirs != null && !customCompileDirs.isEmpty()) {
            Arrays.asList(customCompileDirs.split(CUSTOM_COMPILE_DIR_SEPARATOR)).forEach(d -> srcDirs.add(FileHelper.getAbsolutePath(d.trim()).toString()));
        } else {
            srcDirs.addAll(FileHelper.getDefaultStepImplDirs());
        }
        return srcDirs;
    }

    public static String getClassName(File filepath) {
        String fileName = filepath.getName();
        return com.google.common.io.Files.getNameWithoutExtension((String)fileName);
    }

    public static File getDefaultImplFileName(String suffix, int count) {
        String filename = "StepImplementation" + suffix + JAVA_FILE_EXT;
        Path filepath = Path.of(FileHelper.getDefaultStepImplDir(), filename);
        File file = new File(filepath.toString());
        return file.exists() ? FileHelper.getDefaultImplFileName(String.valueOf(++count), count) : file;
    }

    private static String getDefaultStepImplDir() {
        return FileHelper.getAbsolutePath("src/test/java").toString();
    }

    private static List<String> getDefaultStepImplDirs() {
        ArrayList<String> dirs = new ArrayList<String>();
        for (String dir : GaugeConstant.DEFAULT_SRC_DIRS) {
            Path dirAbsPath = FileHelper.getAbsolutePath(dir.trim());
            if (!Files.exists(dirAbsPath, new LinkOption[0])) continue;
            dirs.add(dirAbsPath.toString());
        }
        return dirs;
    }
}

