/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.execution;

import com.thoughtworks.gauge.execution.ExecutionStage;
import gauge.messages.Spec;

public abstract class AbstractExecutionStage
implements ExecutionStage {
    @Override
    public Spec.ProtoExecutionResult executeNext(Spec.ProtoExecutionResult previousStageResult) {
        if (this.next() != null) {
            return this.next().execute(previousStageResult);
        }
        return previousStageResult;
    }

    protected Spec.ProtoExecutionResult mergeExecResults(Spec.ProtoExecutionResult previousStageResult, Spec.ProtoExecutionResult execResult) {
        long execTime = execResult.getExecutionTime() + previousStageResult.getExecutionTime();
        boolean failed = execResult.getFailed() | previousStageResult.getFailed();
        boolean skipped = execResult.getSkipScenario() | previousStageResult.getSkipScenario();
        Spec.ProtoExecutionResult.Builder builder = Spec.ProtoExecutionResult.newBuilder();
        builder.setExecutionTime(execTime);
        builder.setFailed(failed);
        builder.setSkipScenario(skipped);
        if (previousStageResult.getFailed()) {
            builder.setErrorMessage(previousStageResult.getErrorMessage());
            builder.setErrorType(previousStageResult.getErrorType());
            builder.setFailureScreenshotFile(previousStageResult.getFailureScreenshotFile());
            builder.setStackTrace(previousStageResult.getStackTrace());
            builder.setRecoverableError(previousStageResult.getRecoverableError());
        } else if (execResult.getFailed()) {
            builder.setErrorType(execResult.getErrorType());
            builder.setErrorMessage(execResult.getErrorMessage());
            builder.setFailureScreenshotFile(execResult.getFailureScreenshotFile());
            builder.setStackTrace(execResult.getStackTrace());
            builder.setRecoverableError(execResult.getRecoverableError());
        }
        if (previousStageResult.getRecoverableError() && execResult.getFailed()) {
            builder.setRecoverableError(execResult.getRecoverableError());
        }
        return builder.build();
    }

    protected abstract ExecutionStage next();
}

