/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.screenshot;

import com.thoughtworks.gauge.ClassInstanceManager;
import com.thoughtworks.gauge.Logger;
import com.thoughtworks.gauge.screenshot.CustomScreenshot;
import com.thoughtworks.gauge.screenshot.CustomScreenshotWriter;
import com.thoughtworks.gauge.screenshot.ICustomScreenshotGrabber;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.file.Path;
import java.util.UUID;
import javax.imageio.ImageIO;

public class ScreenshotFactory {
    public static final String IMAGE_EXTENSION = "png";
    private static Class<? extends CustomScreenshot> customScreenshotGrabber;
    private final ClassInstanceManager manager;

    public ScreenshotFactory(ClassInstanceManager manager) {
        this.manager = manager;
    }

    static void setCustomScreenshotGrabber(Class<? extends CustomScreenshot> customScreenGrabber) {
        customScreenshotGrabber = customScreenGrabber;
    }

    public String getScreenshotBytes() {
        return this.takeScreenshot();
    }

    private String takeScreenshot() {
        if (customScreenshotGrabber != null) {
            try {
                CustomScreenshot customScreenInstance = (CustomScreenshot)this.manager.get(customScreenshotGrabber);
                if (customScreenInstance instanceof CustomScreenshotWriter) {
                    CustomScreenshotWriter writer = (CustomScreenshotWriter)customScreenInstance;
                    return writer.takeScreenshot();
                }
                byte[] bytes = ((ICustomScreenshotGrabber)customScreenInstance).takeScreenshot();
                File file = this.generateUniqueScreenshotFile();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
                BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
                ImageIO.write((RenderedImage)bufferedImage, IMAGE_EXTENSION, file);
                return file.getName();
            }
            catch (Exception e) {
                Logger.error(String.format("Failed to take Custom screenshot: %s : %s", customScreenshotGrabber.getCanonicalName(), e.getMessage()));
                Logger.warning("Capturing regular screenshot..");
            }
        }
        return this.captureScreen();
    }

    private File generateUniqueScreenshotFile() {
        String fileName = String.format("screenshot-%s.%s", UUID.randomUUID().toString(), IMAGE_EXTENSION);
        Path path = Path.of(System.getenv("gauge_screenshots_dir"), fileName);
        return new File(path.toAbsolutePath().toString());
    }

    private String captureScreen() {
        File file = this.generateUniqueScreenshotFile();
        try {
            Rectangle screenRect = new Rectangle(0, 0, 0, 0);
            for (GraphicsDevice gd : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                screenRect = screenRect.union(gd.getDefaultConfiguration().getBounds());
            }
            BufferedImage image = new Robot().createScreenCapture(screenRect);
            ImageIO.write((RenderedImage)image, IMAGE_EXTENSION, file);
        }
        catch (Throwable e) {
            Logger.error("Failed to take regular screenshot: " + e.getMessage());
        }
        return file.getName();
    }
}

