/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.execution;

import com.thoughtworks.gauge.ClassInstanceManager;
import com.thoughtworks.gauge.ExecutionContext;
import com.thoughtworks.gauge.Operator;
import com.thoughtworks.gauge.execution.MethodExecutor;
import com.thoughtworks.gauge.hook.Hook;
import com.thoughtworks.gauge.tag.TagMatcher;
import gauge.messages.Spec;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class HooksExecutor {
    private final List<Hook> hooks;
    private final ExecutionContext info;
    private final ClassInstanceManager manager;

    public HooksExecutor(List<Hook> hooks, ExecutionContext executionInfo, ClassInstanceManager manager) {
        this.hooks = hooks;
        this.info = executionInfo;
        this.manager = manager;
    }

    public Spec.ProtoExecutionResult execute() {
        long totalHooksExecutionTime = 0L;
        for (Hook hook : this.hooks) {
            Spec.ProtoExecutionResult result = new TaggedHookExecutor(hook, this.info).execute();
            totalHooksExecutionTime += result.getExecutionTime();
            if (!result.getFailed()) continue;
            return Spec.ProtoExecutionResult.newBuilder(result).setExecutionTime(totalHooksExecutionTime).build();
        }
        return Spec.ProtoExecutionResult.newBuilder().setFailed(false).setExecutionTime(totalHooksExecutionTime).build();
    }

    private boolean methodHasArguments(Method method, Object ... arg) {
        if (method.getParameterTypes().length != arg.length) {
            return false;
        }
        List<Class<?>> argsClassList = this.createClassList(arg);
        Class<?>[] parameterTypes = method.getParameterTypes();
        boolean isValid = true;
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (argsClassList.indexOf(parameterTypes[i]) == i) continue;
            isValid = false;
        }
        return isValid;
    }

    private List<Class<?>> createClassList(Object[] objects) {
        ArrayList classes = new ArrayList();
        for (Object obj : objects) {
            classes.add(obj.getClass());
        }
        return classes;
    }

    private class TaggedHookExecutor {
        private final Hook hook;
        private final ExecutionContext info;

        TaggedHookExecutor(Hook hook, ExecutionContext info) {
            this.hook = hook;
            this.info = info;
        }

        public Spec.ProtoExecutionResult execute() {
            if (this.tagsMatch(this.hook.getTags(), this.hook.getTagsAggregation(), this.info.getAllTags())) {
                return this.executeHook();
            }
            return Spec.ProtoExecutionResult.newBuilder().setExecutionTime(0L).setFailed(false).build();
        }

        private boolean tagsMatch(List<String> tags, Operator tagsAggregation, List<String> allTags) {
            return new TagMatcher().isMatch(tags, tagsAggregation, allTags);
        }

        private Spec.ProtoExecutionResult executeHook() {
            MethodExecutor methodExecutor = new MethodExecutor(HooksExecutor.this.manager);
            if (HooksExecutor.this.methodHasArguments(this.hook.getMethod(), this.info)) {
                return methodExecutor.execute(this.hook.getMethod(), this.info);
            }
            Spec.ProtoExecutionResult result = methodExecutor.execute(this.hook.getMethod(), new Object[0]);
            return result.toBuilder().setRecoverableError(false).build();
        }
    }
}

