/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.execution.parameters.parsers.types;

import com.google.common.base.Throwables;
import com.thoughtworks.gauge.execution.parameters.ParsingException;
import com.thoughtworks.gauge.execution.parameters.parsers.base.ParameterParser;
import com.thoughtworks.gauge.execution.parameters.parsers.types.PrimitivesConverter;
import gauge.messages.Spec;

public class PrimitiveParameterParser
implements ParameterParser {
    private final PrimitivesConverter primitivesConverter;

    public PrimitiveParameterParser(PrimitivesConverter primitivesConverter) {
        this.primitivesConverter = primitivesConverter;
    }

    @Override
    public boolean canParse(Class<?> parameterType, Spec.Parameter parameter) {
        return this.primitivesConverter.contains(parameterType);
    }

    @Override
    public Object parse(Class<?> parameterType, Spec.Parameter parameter) throws ParsingException {
        try {
            return this.primitivesConverter.convert(parameterType, parameter);
        }
        catch (Exception e) {
            throw new ParsingException(Spec.ProtoExecutionResult.newBuilder().setFailed(true).setExecutionTime(0L).setStackTrace(Throwables.getStackTraceAsString((Throwable)e)).setErrorMessage(String.format("Failed to convert argument from type String to type %s. %s", parameterType.toString(), e.getMessage())).build());
        }
    }
}

