package com.tinet.clink.cc.request.exten;

import com.tinet.clink.cc.PathEnum;
import com.tinet.clink.cc.response.exten.ListExtensResponse;
import com.tinet.clink.core.request.AbstractRequestModel;


/**
 * 查询话机列表请求
 *
 * @author wangyq
 * @date 2018/10/26
 */
public class ListExtensRequest extends AbstractRequestModel<ListExtensResponse> {

    /**
     * 话机区号
     */
    private String areaCode;

    /**
     * 话机类型，1: 分机， 2: 软电话
     */
    private Integer type;

    /**
     * 偏移量，范围 0-10000，默认值为 0
     */
    private Integer offset;

    /**
     * 查询条数，范围 10-100，默认值为 10
     */
    private Integer limit;

    public ListExtensRequest() {
        super(PathEnum.ListExtens.value());
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
        if (areaCode != null) {
            putQueryParameter("areaCode", areaCode);
        }
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
        if (type != null) {
            putQueryParameter("type", type);
        }
    }

    public Integer getOffset() {
        return offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
        if (offset != null) {
            putQueryParameter("offset", offset);
        }
    }

    public Integer getLimit() {
        return limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
        if (limit != null) {
            putQueryParameter("limit", limit);
        }
    }

    @Override
    public Class<ListExtensResponse> getResponseClass() {
        return ListExtensResponse.class;
    }
}