package com.tinet.clink.kb.request;

import com.tinet.clink.kb.PathEnum;
import com.tinet.clink.core.request.AbstractRequestModel;
import com.tinet.clink.core.utils.HttpMethodType;
import com.tinet.clink.kb.response.ListDirectoriesResponse;

/**
 * 知识库目录列表请求
 *
 * @author feizq
 * @date 2021/06/25
 **/
public class ListDirectoriesRequest extends AbstractRequestModel<ListDirectoriesResponse> {

    /**
     * 知识库名称
     */
    private String name;

    /**
     * 知识库类型 ，0 问答库 1 文档库
     */
    private Integer type;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
        if (name != null) {
            putQueryParameter("name", name);
        }
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
        if (type != null) {
            putQueryParameter("type", type);
        }
    }

    public ListDirectoriesRequest(){
        super(PathEnum.ListDirectories.value(), HttpMethodType.GET);
    }

    @Override
    public Class<ListDirectoriesResponse> getResponseClass() {
        return ListDirectoriesResponse.class;
    }
}
