package com.tinet.clink.livechat.request;

import com.tinet.clink.livechat.PathEnum;
import com.tinet.clink.core.request.AbstractRequestModel;
import com.tinet.clink.core.utils.HttpMethodType;
import com.tinet.clink.livechat.response.ChatInvestigationResponse;

/**
 * @author Wangyl
 * @date 2020/7/29
 */
public class ChatInvestigationRequest extends AbstractRequestModel<ChatInvestigationResponse> {

    private String scrollId;
    private String date;
    private Integer limit;
    private String mainUniqueId;

    public String getMainUniqueId() {
        return mainUniqueId;
    }

    public void setMainUniqueId(String mainUniqueId) {
        this.mainUniqueId = mainUniqueId;
        if (mainUniqueId != null) {
            putQueryParameter("mainUniqueId", mainUniqueId);
        }
    }

    public String getScrollId() {
        return scrollId;
    }

    public void setScrollId(String scrollId) {
        this.scrollId = scrollId;
        if (scrollId != null) {
            putQueryParameter("scrollId", scrollId);
        }
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
        if (date != null) {
            putQueryParameter("date", date);
        }
    }

    public Integer getLimit() {
        return limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
        if (limit != null) {
            putQueryParameter("limit", limit);
        }
    }

    public ChatInvestigationRequest() {
        super(PathEnum.ChatInvestigation.value(), HttpMethodType.GET);
    }



    @Override
    public Class<ChatInvestigationResponse> getResponseClass() {
        return ChatInvestigationResponse.class;
    }
}
