package com.tinet.clink.livechat.request;

import com.tinet.clink.livechat.PathEnum;
import com.tinet.clink.core.request.AbstractRequestModel;
import com.tinet.clink.core.utils.HttpMethodType;
import com.tinet.clink.livechat.response.ChatMessageResponse;

/**
 * @author yuqiang
 * @date 2021/10/20
 */
public class ListChatMessageRequest extends AbstractRequestModel<ChatMessageResponse> {

    private String scrollId;
    @Deprecated
    private String date;
    private Integer limit;
    private String mainUniqueId;

    public String getScrollId() {
        return scrollId;
    }

    public void setScrollId(String scrollId) {
        this.scrollId = scrollId;
        if (scrollId != null) {
            putQueryParameter("scrollId", scrollId);
        }
    }

    public String getDate() {
        return date;
    }

    @Deprecated
    public void setDate(String date) {
        this.date = date;
        if (date != null) {
            putQueryParameter("date", date);
        }
    }

    public Integer getLimit() {
        return limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
        if (limit != null) {
            putQueryParameter("limit", limit);
        }
    }

    public String getMainUniqueId() {
        return mainUniqueId;
    }

    public void setMainUniqueId(String mainUniqueId) {
        this.mainUniqueId = mainUniqueId;
        if (mainUniqueId != null) {
            putQueryParameter("mainUniqueId", mainUniqueId);
        }
    }

    public ListChatMessageRequest() {
        super(PathEnum.ChatMessageDetail.value(), HttpMethodType.GET);
    }

    @Override
    public Class<ChatMessageResponse> getResponseClass() {
        return ChatMessageResponse.class;
    }
}
