/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.platform.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tibco.bw.maven.plugin.admin.client.ClientException;
import com.tibco.bw.maven.plugin.platform.client.BaseImage;
import com.tibco.bw.maven.plugin.platform.client.BuildType;
import com.tibco.bw.maven.plugin.platform.client.BuildTypeCatalog;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.maven.plugin.logging.Log;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.json.JSONArray;
import org.json.JSONObject;

public class PlatformDeployer {
    private final int connectTimeout;
    private final int readTimeout;
    private final int retryCount;
    private Log log;
    private WebTarget webTarget;

    public PlatformDeployer(int connectTimeout, int readTimeout, int retryCount, Log log) {
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.retryCount = retryCount;
        this.log = log;
    }

    public void buildApp(String earPath, String buildName, String appName, String profile, int replicas, boolean enableAutoScaling, boolean enableServiceMesh, boolean eula, String platformConfigFile, String dpUrl, String authToken, String baseVersion, String baseImageTag, String namespace, boolean deploy) throws ClientException, IOException, InterruptedException {
        try {
            JSONArray platformConfigObject;
            JSONObject rootObject;
            this.log.info((CharSequence)"Application build creation in Platform started...");
            if (dpUrl == null) {
                throw new ClientException("Unable to build the application. Please provide the data plane URL.");
            }
            if (authToken == null) {
                throw new ClientException("Unable to build the application. Please provide authorization token.");
            }
            if (baseVersion == null) {
                throw new ClientException("Unable to build the application. Please provide base version.");
            }
            if (baseImageTag == null) {
                throw new ClientException("Unable to build the application. Please provide base image tag.");
            }
            if (namespace == null) {
                throw new ClientException("Unable to build the application. Please provide namespace.");
            }
            File ear = new File(earPath);
            this.log.debug((CharSequence)("EarLocation : " + earPath + ", EarFile : " + ear.getName()));
            Client client = ClientBuilder.newClient();
            this.webTarget = client.target(new URI(dpUrl));
            this.webTarget.register(MultiPartFeature.class);
            Response bwceVersionsResponse = this.webTarget.path("public/v1/dp/bwceversions").request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + authToken)).get();
            if (bwceVersionsResponse != null && bwceVersionsResponse.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                boolean isBaseVersionValid = false;
                boolean isBaseImageValid = false;
                String readEntity = (String)bwceVersionsResponse.readEntity(String.class);
                ObjectMapper mapper = new ObjectMapper();
                mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
                BuildTypeCatalog buildTypeCatalog = (BuildTypeCatalog)mapper.readValue(readEntity, BuildTypeCatalog.class);
                block3: for (BuildType buildType : buildTypeCatalog.getBuildtypeCatalog()) {
                    if (!buildType.getBuildtypeTag().equals(baseVersion)) continue;
                    isBaseVersionValid = true;
                    List<BaseImage> baseImages = buildType.getBaseImages();
                    for (BaseImage image : baseImages) {
                        if (!image.getImageTag().equals(baseImageTag)) continue;
                        isBaseImageValid = true;
                        continue block3;
                    }
                }
                if (!isBaseVersionValid) {
                    throw new ClientException("Unable to build the application. Please provide a valid base version.");
                }
                if (!isBaseImageValid) {
                    throw new ClientException("Unable to build the application. Please provide a valid base image tag.");
                }
            }
            String platformConfigFileContent = new String(Files.readAllBytes(Paths.get(platformConfigFile, new String[0])));
            JSONArray dependenciesArray = null;
            JSONArray tagsArray = null;
            if (platformConfigFileContent != null && !platformConfigFileContent.isEmpty() && (rootObject = new JSONObject(platformConfigFileContent)) != null && rootObject.has("platformConfig") && (platformConfigObject = (JSONArray)rootObject.get("platformConfig")) != null) {
                JSONObject tags;
                JSONObject dependencies;
                if (platformConfigObject.length() > 2 && (dependencies = (JSONObject)platformConfigObject.get(2)) != null) {
                    dependenciesArray = (JSONArray)dependencies.get("dependencies");
                }
                if (platformConfigObject.length() > 6 && (tags = (JSONObject)platformConfigObject.get(6)) != null) {
                    tagsArray = (JSONArray)tags.get("tags");
                }
            }
            FormDataMultiPart multipart = new FormDataMultiPart();
            multipart.bodyPart((BodyPart)new FileDataBodyPart("artifact", ear));
            multipart.bodyPart((BodyPart)new FormDataBodyPart("request", "{\"buildName\": \"" + buildName + "\", \"dependencies\": " + dependenciesArray.toString() + ", \"tags\": " + tagsArray.toString() + "}"));
            Response response = this.webTarget.queryParam("baseversion", new Object[]{baseVersion}).queryParam("baseimagetag", new Object[]{baseImageTag}).path("public/v1/dp/builds").request(new String[]{"multipart/form-data"}).accept(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + authToken)).post(Entity.entity((Object)multipart, (String)"multipart/form-data"));
            Response.StatusType statusInfo = response.getStatusInfo();
            if (statusInfo.getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                if (deploy) {
                    String readEntity = (String)response.readEntity(String.class);
                    ObjectMapper mapper = new ObjectMapper();
                    mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
                    Map responseMap = (Map)mapper.readValue(readEntity, Map.class);
                    String buildId = (String)responseMap.get("buildId");
                    this.deployApp(null, buildId, namespace, authToken, eula, replicas, appName, profile, platformConfigFile, enableAutoScaling, enableServiceMesh, true);
                }
            } else {
                this.processErrorResponse(response, statusInfo);
            }
        }
        catch (ProcessingException pe) {
            pe.printStackTrace();
            throw PlatformDeployer.getConnectionException(pe);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ClientException(500, ex.getMessage(), ex);
        }
    }

    public void deployApp(String appId, String buildId, String namespace, String authToken, boolean eula, int replicas, String appName, String profile, String platformConfigFile, boolean enableAutoScaling, boolean enableServiceMesh, boolean scale) throws ClientException, IOException, InterruptedException {
        Response response;
        Response.StatusType statusInfo;
        JSONArray platformConfigObject;
        JSONObject rootObject;
        if (buildId == null || buildId.isEmpty()) {
            throw new ClientException("Unable to deploy the application. Please provide a valid build ID.");
        }
        if (namespace == null || namespace.isEmpty()) {
            throw new ClientException("Unable to deploy the application. Please provide a valid namespace.");
        }
        if (!eula) {
            throw new ClientException("Unable to deploy the application. Please accept the EULA.");
        }
        JSONObject appJsonObject = new JSONObject();
        String platformConfigFileContent = new String(Files.readAllBytes(Paths.get(platformConfigFile, new String[0])));
        if (platformConfigFileContent != null && !platformConfigFileContent.isEmpty() && (rootObject = new JSONObject(platformConfigFileContent)) != null && rootObject.has("platformConfig") && (platformConfigObject = (JSONArray)rootObject.get("platformConfig")) != null) {
            JSONObject tags;
            JSONObject networkPolicies;
            JSONObject autoscalingConfig;
            JSONObject resourceLimits;
            JSONObject systemProperties;
            JSONObject appProperties;
            JSONArray appPropertiesArray = null;
            JSONArray systemPropertiesArray = null;
            JSONObject resourceLimitsArray = null;
            JSONObject autoscalingConfigObject = null;
            JSONObject networkPoliciesObject = null;
            JSONArray tagsArray = null;
            if (platformConfigObject.length() > 0 && (appProperties = (JSONObject)platformConfigObject.get(0)) != null) {
                appPropertiesArray = (JSONArray)appProperties.get("appProperties");
            }
            if (platformConfigObject.length() > 1 && (systemProperties = (JSONObject)platformConfigObject.get(1)) != null) {
                systemPropertiesArray = (JSONArray)systemProperties.get("systemProperties");
            }
            if (platformConfigObject.length() > 3 && (resourceLimits = (JSONObject)platformConfigObject.get(3)) != null) {
                resourceLimitsArray = (JSONObject)resourceLimits.get("resourceLimits");
            }
            if (enableAutoScaling && platformConfigObject.length() > 4 && (autoscalingConfig = (JSONObject)platformConfigObject.get(4)) != null) {
                autoscalingConfigObject = (JSONObject)autoscalingConfig.get("autoscalingConfig");
            }
            if (platformConfigObject.length() > 5 && (networkPolicies = (JSONObject)platformConfigObject.get(5)) != null) {
                networkPoliciesObject = (JSONObject)networkPolicies.get("networkPolicies");
            }
            if (platformConfigObject.length() > 6 && (tags = (JSONObject)platformConfigObject.get(6)) != null) {
                tagsArray = (JSONArray)tags.get("tags");
            }
            if (appId != null && !appId.isEmpty()) {
                appJsonObject.put("appId", (Object)appId);
            }
            appJsonObject.put("buildId", (Object)buildId);
            appJsonObject.put("enableAutoScaling", enableAutoScaling);
            appJsonObject.put("enableServiceMesh", enableServiceMesh);
            appJsonObject.put("eula", eula);
            appJsonObject.put("appName", (Object)appName);
            appJsonObject.put("profile", (Object)profile);
            if (appPropertiesArray != null) {
                appJsonObject.put("appProperties", (Object)appPropertiesArray);
            }
            if (systemPropertiesArray != null) {
                appJsonObject.put("systemProperties", (Object)systemPropertiesArray);
            }
            if (resourceLimitsArray != null) {
                appJsonObject.put("resourceLimits", (Object)resourceLimitsArray);
            }
            if (autoscalingConfigObject != null) {
                appJsonObject.put("autoscalingConfig", (Object)autoscalingConfigObject);
            }
            if (networkPoliciesObject != null) {
                appJsonObject.put("networkPolicies", (Object)networkPoliciesObject);
            }
            if (tagsArray != null) {
                appJsonObject.put("tags", (Object)tagsArray);
            }
        }
        if ((statusInfo = (response = this.webTarget.queryParam("namespace", new Object[]{namespace}).path("public/v1/dp/deploy").request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + authToken)).header("Content-Type", (Object)"application/json").post(Entity.entity((Object)appJsonObject.toString(), (String)"application/json"))).getStatusInfo()).getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
            if (scale) {
                String readEntity = (String)response.readEntity(String.class);
                ObjectMapper mapper = new ObjectMapper();
                mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
                Map responseMap = (Map)mapper.readValue(readEntity, Map.class);
                this.scaleApp((String)responseMap.get("appId"), replicas, authToken);
            }
        } else {
            this.processErrorResponse(response, statusInfo);
        }
    }

    public void deployApp(String dpUrl, String buildId, String namespace, String authToken, boolean eula, String appName, String profile, String platformConfigFile, boolean enableAutoScaling, boolean enableServiceMesh) throws ClientException, IOException, InterruptedException {
        try {
            this.log.info((CharSequence)"Build deployment in Platform started...");
            Client client = ClientBuilder.newClient();
            this.webTarget = client.target(new URI(dpUrl));
            this.webTarget.register(MultiPartFeature.class);
            this.deployApp(null, buildId, namespace, authToken, eula, 0, appName, profile, platformConfigFile, enableAutoScaling, enableServiceMesh, false);
        }
        catch (ProcessingException pe) {
            pe.printStackTrace();
            throw PlatformDeployer.getConnectionException(pe);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ClientException(500, ex.getMessage(), ex);
        }
    }

    public void scaleApp(String appId, int replicas, String authToken) throws ClientException, IOException, InterruptedException {
        if (appId == null || appId.isEmpty()) {
            throw new ClientException("Unable to scale the application. Please provide app ID.");
        }
        if (replicas <= 0) {
            throw new ClientException("Unable to scale the application. Please provide a valid number of replicas.");
        }
        Response response = this.webTarget.queryParam("count", new Object[]{Integer.toString(replicas)}).path("public/v1/dp/apps").path(appId).path("scale").request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + authToken)).put(Entity.entity((Object)"", (String)"text/plain"));
        Response.StatusType statusInfo = response.getStatusInfo();
        if (!statusInfo.getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
            this.processErrorResponse(response, statusInfo);
        }
    }

    public void scaleApp(String dpUrl, String appId, int replicas, String authToken) throws ClientException, IOException, InterruptedException {
        try {
            this.log.info((CharSequence)"Applicatoin scaling in Platform started...");
            Client client = ClientBuilder.newClient();
            this.webTarget = client.target(new URI(dpUrl));
            this.webTarget.register(MultiPartFeature.class);
            this.scaleApp(appId, replicas, authToken);
        }
        catch (ProcessingException pe) {
            pe.printStackTrace();
            throw PlatformDeployer.getConnectionException(pe);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ClientException(500, ex.getMessage(), ex);
        }
    }

    public void upgradeApp(String dpUrl, String appId, String buildId, String namespace, String authToken, boolean eula, String appName, String profile, String platformConfigFile, boolean enableAutoScaling, boolean enableServiceMesh) throws ClientException, IOException, InterruptedException {
        try {
            this.log.info((CharSequence)"Application upgrade in Platform started...");
            Client client = ClientBuilder.newClient();
            this.webTarget = client.target(new URI(dpUrl));
            this.webTarget.register(MultiPartFeature.class);
            this.deployApp(appId, buildId, namespace, authToken, eula, 0, appName, profile, platformConfigFile, enableAutoScaling, enableServiceMesh, false);
        }
        catch (ProcessingException pe) {
            pe.printStackTrace();
            throw PlatformDeployer.getConnectionException(pe);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ClientException(500, ex.getMessage(), ex);
        }
    }

    private void processErrorResponse(Response response, Response.StatusType statusInfo) throws ClientException {
        if (statusInfo.getStatusCode() == 401) {
            throw new ClientException(response.getStatus(), statusInfo.getStatusCode() + ": " + statusInfo.getReasonPhrase(), null);
        }
        String error = (String)response.readEntity(String.class);
        if (error != null) {
            String errCode = null;
            String errMsg = null;
            String errDetail = null;
            try {
                ObjectMapper mapper = new ObjectMapper();
                mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
                Map responseMap = (Map)mapper.readValue(error, Map.class);
                errCode = (String)responseMap.get("errCode");
                errMsg = (String)responseMap.get("errMsg");
                errDetail = (String)responseMap.get("errDetail");
            }
            catch (JsonMappingException e) {
                e.printStackTrace();
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            throw new ClientException(response.getStatus(), "Error code: " + errCode + "\nError message: " + errMsg + "\nError details: " + errDetail, null);
        }
        throw new ClientException(response.getStatus(), statusInfo.getReasonPhrase(), null);
    }

    private static ClientException getConnectionException(ProcessingException pe) {
        if (pe.getCause() instanceof ConnectException) {
            return new ClientException(503, pe.getCause().getMessage(), pe.getCause());
        }
        if (pe.getCause() instanceof IllegalStateException) {
            return new ClientException(503, pe.getCause().getMessage(), pe.getCause());
        }
        return new ClientException(500, pe.getMessage(), pe);
    }
}

