/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.test.report;

import com.tibco.bw.maven.plugin.test.dto.CompleteReportDTO;
import com.tibco.bw.maven.plugin.test.helpers.BWTestConfig;
import com.tibco.bw.maven.plugin.test.report.BWTestSuiteReportParser;
import java.util.List;
import java.util.Map;
import org.apache.maven.doxia.markup.HtmlMarkup;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.doxia.util.DoxiaUtils;

public class BWTestReportGenerator {
    private static final int LEFT = 1;
    private static final Object[] TAG_TYPE_START = new Object[]{2};
    private static final Object[] TAG_TYPE_END = new Object[]{3};
    private CompleteReportDTO result;
    private BWTestSuiteReportParser bwTestParser;
    private static boolean showFailureProcessname = true;

    public void generateReport(CompleteReportDTO result, Sink sink) {
        this.result = result;
        this.bwTestParser = new BWTestSuiteReportParser(result);
        sink.head();
        sink.title();
        sink.text("BW Report");
        sink.title_();
        sink.head_();
        sink.body();
        SinkEventAttributeSet atts = new SinkEventAttributeSet();
        atts.addAttribute((Object)"type", (Object)"text/javascript");
        sink.unknown("script", new Object[]{2}, (SinkEventAttributes)atts);
        sink.unknown("cdata", new Object[]{5, BWTestReportGenerator.javascriptToggleDisplayCode()}, null);
        sink.unknown("script", new Object[]{3}, null);
        sink.section1();
        sink.sectionTitle1();
        sink.text("BW Test Report");
        sink.sectionTitle1_();
        sink.section1_();
        this.constructSummarySection(sink);
        if (null != BWTestConfig.INSTANCE.getTestSuiteName() && !BWTestConfig.INSTANCE.getTestSuiteName().isEmpty()) {
            this.constructTestSuiteSummarySection(sink);
            this.constructTestSuiteWiseSection(sink);
            if (this.bwTestParser.isShowFailureDetails() && showFailureProcessname) {
                this.constructFailureDetailsSectionForTestSuite(sink);
            }
        } else {
            this.constructPackagesSection(sink);
            this.constructTestCasesSection(sink);
            if (this.bwTestParser.isShowFailureDetails() && showFailureProcessname) {
                this.constructFailureDetailsSection(sink);
            }
        }
        sink.body_();
        sink.flush();
        sink.close();
    }

    private void constructSummarySection(Sink sink) {
        sink.section1();
        sink.sectionTitle1();
        sink.text("Summary");
        sink.sectionTitle1_();
        BWTestReportGenerator.sinkAnchor(sink, "Summary");
        this.constructHotLinks(sink);
        BWTestReportGenerator.sinkLineBreak(sink);
        sink.table();
        sink.tableRows(new int[]{1, 1, 1, 1, 1}, true);
        sink.tableRow();
        BWTestReportGenerator.sinkHeader(sink, "Tests");
        BWTestReportGenerator.sinkHeader(sink, "Errors");
        BWTestReportGenerator.sinkHeader(sink, "Failures");
        BWTestReportGenerator.sinkHeader(sink, "Skipped");
        BWTestReportGenerator.sinkHeader(sink, "Success Rate");
        sink.tableRow_();
        sink.tableRow();
        BWTestReportGenerator.sinkCell(sink, this.bwTestParser.getSummary().getTotalTests());
        BWTestReportGenerator.sinkCell(sink, this.bwTestParser.getSummary().getErrors());
        BWTestReportGenerator.sinkCell(sink, this.bwTestParser.getSummary().getFailures());
        BWTestReportGenerator.sinkCell(sink, this.bwTestParser.getSummary().getSkipped());
        BWTestReportGenerator.sinkCell(sink, this.bwTestParser.getSummary().getPercentage() + "%");
        sink.tableRow_();
        sink.tableRows_();
        sink.table_();
        BWTestReportGenerator.sinkLineBreak(sink);
        sink.section1_();
    }

    private void constructPackagesSection(Sink sink) {
        String packageName;
        sink.section1();
        sink.sectionTitle1();
        sink.text("Package List");
        sink.sectionTitle1_();
        BWTestReportGenerator.sinkAnchor(sink, "Package_List");
        this.constructHotLinks(sink);
        BWTestReportGenerator.sinkLineBreak(sink);
        sink.table();
        sink.tableRows(new int[]{1, 1, 1, 1, 1, 1, 1}, true);
        sink.tableRow();
        BWTestReportGenerator.sinkHeader(sink, "Module");
        BWTestReportGenerator.sinkHeader(sink, "Package");
        BWTestReportGenerator.sinkHeader(sink, "Test");
        BWTestReportGenerator.sinkHeader(sink, "Errors");
        BWTestReportGenerator.sinkHeader(sink, "Failures");
        BWTestReportGenerator.sinkHeader(sink, "Skipped");
        BWTestReportGenerator.sinkHeader(sink, "Success Rate");
        sink.tableRow_();
        for (Map.Entry<String, BWTestSuiteReportParser.PackageTestDetails> entry : this.bwTestParser.getPackageMap().entrySet()) {
            sink.tableRow();
            packageName = entry.getKey();
            BWTestSuiteReportParser.PackageTestDetails packageDetails = entry.getValue();
            BWTestReportGenerator.sinkCell(sink, packageDetails.getModuleName());
            BWTestReportGenerator.sinkCellLink(sink, packageName, "#" + packageName);
            BWTestReportGenerator.sinkCell(sink, String.valueOf(packageDetails.getTotalTests()));
            BWTestReportGenerator.sinkCell(sink, String.valueOf(packageDetails.getErrors()));
            BWTestReportGenerator.sinkCell(sink, String.valueOf(packageDetails.getFailures()));
            BWTestReportGenerator.sinkCell(sink, "0");
            BWTestReportGenerator.sinkCell(sink, packageDetails.getSuccessRate() + "%");
            sink.tableRow_();
        }
        sink.tableRows_();
        sink.table_();
        sink.lineBreak();
        for (Map.Entry<String, BWTestSuiteReportParser.PackageTestDetails> entry : this.bwTestParser.getPackageMap().entrySet()) {
            packageName = entry.getKey();
            List<BWTestSuiteReportParser.ProcessTestDetails> testSuiteList = entry.getValue().getProcessDetails();
            sink.section2();
            sink.sectionTitle2();
            sink.text(packageName);
            sink.sectionTitle2_();
            BWTestReportGenerator.sinkAnchor(sink, packageName);
            boolean showTable = false;
            sink.table();
            sink.tableRows(new int[]{1, 1, 1, 1, 1, 1, 1}, true);
            sink.tableRow();
            BWTestReportGenerator.sinkHeader(sink, "");
            BWTestReportGenerator.sinkHeader(sink, "Class");
            BWTestReportGenerator.sinkHeader(sink, "Tests");
            BWTestReportGenerator.sinkHeader(sink, "Errors");
            BWTestReportGenerator.sinkHeader(sink, "Failures");
            BWTestReportGenerator.sinkHeader(sink, "Skipped");
            BWTestReportGenerator.sinkHeader(sink, "Success Rate");
            sink.tableRow_();
            for (BWTestSuiteReportParser.ProcessTestDetails suite : testSuiteList) {
                this.constructTestSuiteSection(sink, suite, packageName);
            }
            sink.tableRows_();
            sink.table_();
            sink.section2_();
        }
        BWTestReportGenerator.sinkLineBreak(sink);
        sink.section1_();
    }

    private void constructTestSuiteSummarySection(Sink sink) {
        sink.section1();
        sink.sectionTitle1();
        sink.text("Test Suite List");
        sink.sectionTitle1_();
        BWTestReportGenerator.sinkAnchor(sink, "TestSuite_List");
        this.constructHotLinks(sink);
        BWTestReportGenerator.sinkLineBreak(sink);
        sink.table();
        sink.tableRows(new int[]{1, 1, 1, 1, 1, 1, 1}, true);
        sink.tableRow();
        BWTestReportGenerator.sinkHeader(sink, "Test Suite");
        BWTestReportGenerator.sinkHeader(sink, "Module");
        BWTestReportGenerator.sinkHeader(sink, "Test");
        BWTestReportGenerator.sinkHeader(sink, "Errors");
        BWTestReportGenerator.sinkHeader(sink, "Failures");
        BWTestReportGenerator.sinkHeader(sink, "Skipped");
        BWTestReportGenerator.sinkHeader(sink, "Success Rate");
        sink.tableRow_();
        for (Map.Entry<String, BWTestSuiteReportParser.TestSuiteDetails> entry : this.bwTestParser.getTestSuiteMap().entrySet()) {
            sink.tableRow();
            String testSuiteName = entry.getKey();
            BWTestSuiteReportParser.TestSuiteDetails testSuiteDetails = entry.getValue();
            BWTestReportGenerator.sinkCellLink(sink, testSuiteName, "#" + testSuiteName);
            BWTestReportGenerator.sinkCell(sink, testSuiteDetails.getModuleName());
            BWTestReportGenerator.sinkCell(sink, String.valueOf(testSuiteDetails.getTotalTests()));
            BWTestReportGenerator.sinkCell(sink, String.valueOf(testSuiteDetails.getErrors()));
            BWTestReportGenerator.sinkCell(sink, String.valueOf(testSuiteDetails.getFailures()));
            BWTestReportGenerator.sinkCell(sink, "0");
            BWTestReportGenerator.sinkCell(sink, testSuiteDetails.getSuccessRate() + "%");
            sink.tableRow_();
        }
        sink.tableRows_();
        sink.table_();
        BWTestReportGenerator.sinkLineBreak(sink);
        sink.section1_();
    }

    private void constructTestSuiteSection(Sink sink, BWTestSuiteReportParser.ProcessTestDetails suite, String packageName) {
        sink.tableRow();
        sink.tableCell();
        sink.link("#" + packageName + "." + suite.getProcessName());
        if (suite.getFailures() > 0) {
            BWTestReportGenerator.sinkIcon("error", sink);
        } else {
            BWTestReportGenerator.sinkIcon("success", sink);
        }
        sink.link_();
        sink.tableCell_();
        BWTestReportGenerator.sinkCellLink(sink, suite.getProcessName(), "#" + packageName + "." + suite.getProcessName());
        BWTestReportGenerator.sinkCell(sink, Integer.toString(suite.getTotalTests()));
        BWTestReportGenerator.sinkCell(sink, Integer.toString(suite.getErrors()));
        BWTestReportGenerator.sinkCell(sink, Integer.toString(suite.getFailures()));
        BWTestReportGenerator.sinkCell(sink, "0");
        BWTestReportGenerator.sinkCell(sink, suite.getSuccessRate() + "%");
        sink.tableRow_();
    }

    private void constructTestSuiteTestCaseSection(Sink sink, BWTestSuiteReportParser.ProcessFileTestDetails testCase, Map<String, String> testCaseWithProcessMap) {
        sink.tableRow();
        sink.tableCell();
        if (testCase.getFailures() > 0) {
            showFailureProcessname = true;
            sink.link("#" + BWTestReportGenerator.toHtmlId(testCase.getFileName()));
            BWTestReportGenerator.sinkIcon("error", sink);
            sink.link_();
        } else {
            BWTestReportGenerator.sinkIcon("success", sink);
        }
        sink.tableCell_();
        BWTestReportGenerator.sinkCell(sink, testCase.getFileName());
        String text = String.valueOf(testCase.getTotalAssertions()) + " Assertions run. ";
        if (testCase.getAssertionFailures().size() > 0) {
            text = text + " Assertions failed for Activities " + testCase.getAssertionFailures().toString();
        }
        BWTestReportGenerator.sinkCell(sink, text);
        sink.tableRow_();
    }

    private void constructTestCasesSection(Sink sink) {
        sink.section1();
        sink.sectionTitle1();
        sink.text("Process Test Cases ");
        sink.sectionTitle1_();
        BWTestReportGenerator.sinkAnchor(sink, "Test_Cases");
        this.constructHotLinks(sink);
        for (Map.Entry<String, BWTestSuiteReportParser.PackageTestDetails> entry : this.bwTestParser.getPackageMap().entrySet()) {
            String packageName = entry.getKey();
            List<BWTestSuiteReportParser.ProcessTestDetails> testSuiteList = entry.getValue().getProcessDetails();
            for (BWTestSuiteReportParser.ProcessTestDetails suite : testSuiteList) {
                sink.section2();
                sink.sectionTitle2();
                sink.text(suite.getProcessName());
                sink.sectionTitle2_();
                BWTestReportGenerator.sinkAnchor(sink, packageName + "." + suite.getProcessName());
                sink.table();
                sink.tableRows(new int[]{1, 1, 1}, true);
                for (BWTestSuiteReportParser.ProcessFileTestDetails testCase : suite.getFileTestDetails()) {
                    BWTestReportGenerator.constructTestCaseSection(sink, testCase);
                }
                sink.tableRows_();
                sink.table_();
                sink.section2_();
            }
        }
        BWTestReportGenerator.sinkLineBreak(sink);
        sink.section1_();
    }

    private void constructTestSuiteWiseSection(Sink sink) {
        sink.section1();
        sink.sectionTitle1();
        sink.text("Test Suite Test Cases ");
        sink.sectionTitle1_();
        BWTestReportGenerator.sinkAnchor(sink, "Test_Cases");
        this.constructHotLinks(sink);
        for (Map.Entry<String, BWTestSuiteReportParser.TestSuiteDetails> entry : this.bwTestParser.getTestSuiteMap().entrySet()) {
            String testSuiteName = entry.getKey();
            List<BWTestSuiteReportParser.ProcessTestDetails> testSuiteList = entry.getValue().getProcessDetails();
            for (BWTestSuiteReportParser.ProcessTestDetails suite : testSuiteList) {
                sink.section2();
                sink.sectionTitle2();
                sink.text(suite.getSuiteName().replaceAll(".bwts", ""));
                sink.sectionTitle2_();
                BWTestReportGenerator.sinkAnchor(sink, testSuiteName + "." + suite.getProcessName());
                sink.table();
                sink.tableRows(new int[]{1, 1, 1}, true);
                for (BWTestSuiteReportParser.ProcessFileTestDetails testCase : suite.getFileTestDetails()) {
                    this.constructTestSuiteTestCaseSection(sink, testCase, this.bwTestParser.getTestCaseWithProcessMap());
                }
                sink.tableRows_();
                sink.table_();
                sink.section2_();
            }
        }
        BWTestReportGenerator.sinkLineBreak(sink);
        sink.section1_();
    }

    private void constructFailureDetailsSection(Sink sink) {
        sink.section1();
        sink.sectionTitle1();
        sink.text("Failure Details ");
        sink.sectionTitle1_();
        BWTestReportGenerator.sinkAnchor(sink, "Failure_Details");
        this.constructHotLinks(sink);
        for (Map.Entry<String, BWTestSuiteReportParser.PackageTestDetails> entry : this.bwTestParser.getPackageMap().entrySet()) {
            String packageName = entry.getKey();
            List<BWTestSuiteReportParser.ProcessTestDetails> testSuiteList = entry.getValue().getProcessDetails();
            for (BWTestSuiteReportParser.ProcessTestDetails suite : testSuiteList) {
                sink.section2();
                sink.sectionTitle2();
                sink.text(suite.getProcessName());
                sink.sectionTitle2_();
                BWTestReportGenerator.sinkAnchor(sink, packageName + "." + suite.getProcessName());
                sink.table();
                sink.tableRows(new int[]{1, 1}, true);
                for (BWTestSuiteReportParser.ProcessFileTestDetails testCase : suite.getFileTestDetails()) {
                    BWTestReportGenerator.constructFailureDataSection(sink, testCase);
                }
                sink.tableRows_();
                sink.table_();
                sink.section2_();
            }
        }
        BWTestReportGenerator.sinkLineBreak(sink);
        sink.section1_();
    }

    private void constructFailureDetailsSectionForTestSuite(Sink sink) {
        sink.section1();
        sink.sectionTitle1();
        sink.text("Failure Details ");
        sink.sectionTitle1_();
        BWTestReportGenerator.sinkAnchor(sink, "Failure_Details");
        this.constructHotLinks(sink);
        for (Map.Entry<String, BWTestSuiteReportParser.TestSuiteDetails> entry : this.bwTestParser.getTestSuiteMap().entrySet()) {
            String testSuiteName = entry.getKey();
            List<BWTestSuiteReportParser.ProcessTestDetails> testSuiteList = entry.getValue().getProcessDetails();
            for (BWTestSuiteReportParser.ProcessTestDetails suite : testSuiteList) {
                sink.section2();
                sink.sectionTitle2();
                sink.text(suite.getSuiteName());
                sink.sectionTitle2_();
                BWTestReportGenerator.sinkAnchor(sink, testSuiteName + "." + suite.getSuiteName());
                sink.table();
                sink.tableRows(new int[]{1, 1}, true);
                for (BWTestSuiteReportParser.ProcessFileTestDetails testCase : suite.getFileTestDetails()) {
                    BWTestReportGenerator.constructFailureDataSection(sink, testCase);
                }
                sink.tableRows_();
                sink.table_();
                sink.section2_();
            }
        }
        BWTestReportGenerator.sinkLineBreak(sink);
        sink.section1_();
    }

    private static void constructTestCaseSection(Sink sink, BWTestSuiteReportParser.ProcessFileTestDetails testCase) {
        sink.tableRow();
        sink.tableCell();
        if (testCase.getFailures() > 0) {
            showFailureProcessname = true;
            sink.link("#" + BWTestReportGenerator.toHtmlId(testCase.getFileName()));
            BWTestReportGenerator.sinkIcon("error", sink);
            sink.link_();
        } else {
            BWTestReportGenerator.sinkIcon("success", sink);
        }
        sink.tableCell_();
        BWTestReportGenerator.sinkCell(sink, testCase.getFileName());
        String text = String.valueOf(testCase.getTotalAssertions()) + " Assertions run. ";
        if (testCase.getAssertionFailures().size() > 0) {
            text = text + " Assertions failed for Activities " + testCase.getAssertionFailures().toString();
        }
        BWTestReportGenerator.sinkCell(sink, text);
        sink.tableRow_();
    }

    private static void constructFailureDataSection(Sink sink, BWTestSuiteReportParser.ProcessFileTestDetails testCase) {
        if (testCase.getAssertionFailures().size() > 0) {
            for (String faultData : testCase.getFailureData()) {
                sink.tableRow();
                sink.tableCell();
                sink.link("#" + BWTestReportGenerator.toHtmlId(testCase.getFileName()));
                BWTestReportGenerator.sinkIcon("error", sink);
                sink.link_();
                sink.tableCell_();
                BWTestReportGenerator.sinkCell(sink, testCase.getFileName());
                BWTestReportGenerator.sinkCell(sink, faultData);
                sink.tableRow_();
            }
        } else {
            sink.tableRow();
            sink.tableCell();
            sink.link("#" + BWTestReportGenerator.toHtmlId(testCase.getFileName()));
            BWTestReportGenerator.sinkIcon("success", sink);
            sink.link_();
            sink.tableCell_();
            BWTestReportGenerator.sinkCell(sink, testCase.getFileName());
            BWTestReportGenerator.sinkCell(sink, "No failed assertions found.");
            sink.tableRow_();
        }
    }

    private static String toHtmlId(String id) {
        return DoxiaUtils.isValidId((String)id) ? id : DoxiaUtils.encodeId((String)id);
    }

    private static void sinkIcon(String type, Sink sink) {
        sink.figure();
        if (type.startsWith("junit.framework") || "skipped".equals(type)) {
            sink.figureGraphics("images/icon_warning_sml.gif");
        } else if (type.startsWith("success")) {
            sink.figureGraphics("images/icon_success_sml.gif");
        } else {
            sink.figureGraphics("images/icon_error_sml.gif");
        }
        sink.figure_();
    }

    private void constructHotLinks(Sink sink) {
        sink.paragraph();
        sink.text("[");
        BWTestReportGenerator.sinkLink(sink, "Summary", "#Summary");
        sink.text("]");
        if (null != BWTestConfig.INSTANCE.getTestSuiteName() && !BWTestConfig.INSTANCE.getTestSuiteName().isEmpty()) {
            sink.text(" [");
            BWTestReportGenerator.sinkLink(sink, "Test Suite List", "#TestSuite_List");
            sink.text("]");
        } else {
            sink.text(" [");
            BWTestReportGenerator.sinkLink(sink, "Package List", "#Package_List");
            sink.text("]");
        }
        sink.text(" [");
        BWTestReportGenerator.sinkLink(sink, "Test Cases", "#Test_Cases");
        sink.text("]");
        if (this.bwTestParser.isShowFailureDetails()) {
            sink.text(" [");
            BWTestReportGenerator.sinkLink(sink, "Failure Details", "#Failure_Details");
            sink.text("]");
        }
        sink.paragraph_();
    }

    private static void sinkLineBreak(Sink sink) {
        sink.lineBreak();
    }

    private static void sinkHeader(Sink sink, String header) {
        sink.tableHeaderCell();
        sink.text(header);
        sink.tableHeaderCell_();
    }

    private static void sinkCell(Sink sink, String text) {
        sink.tableCell();
        sink.text(text);
        sink.tableCell_();
    }

    private static void sinkLink(Sink sink, String text, String link) {
        sink.link(link);
        sink.text(text);
        sink.link_();
    }

    private static void sinkCellLink(Sink sink, String text, String link) {
        sink.tableCell();
        BWTestReportGenerator.sinkLink(sink, text, link);
        sink.tableCell_();
    }

    private static void sinkAnchor(Sink sink, String anchor) {
        sink.unknown(HtmlMarkup.A.toString(), TAG_TYPE_START, (SinkEventAttributes)new SinkEventAttributeSet(new String[]{"name", anchor}));
        sink.unknown(HtmlMarkup.A.toString(), TAG_TYPE_END, null);
    }

    private static String javascriptToggleDisplayCode() {
        return "\nfunction toggleDisplay(elementId) {\n var elm = document.getElementById(elementId + '-error');\n if (elm == null) {\n  elm = document.getElementById(elementId + '-failure');\n }\n if (elm && typeof elm.style != \"undefined\") {\n  if (elm.style.display == \"none\") {\n   elm.style.display = \"\";\n   document.getElementById(elementId + '-off').style.display = \"none\";\n   document.getElementById(elementId + '-on').style.display = \"inline\";\n  } else if (elm.style.display == \"\") {   elm.style.display = \"none\";\n   document.getElementById(elementId + '-off').style.display = \"inline\";\n   document.getElementById(elementId + '-on').style.display = \"none\";\n  } \n } \n }\n//";
    }
}

