/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.test.rest;

import com.tibco.bw.maven.plugin.test.dto.TestSuiteDTO;
import com.tibco.bw.maven.plugin.test.helpers.BWTestConfig;
import com.tibco.bw.maven.plugin.test.helpers.TestFileParser;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.project.MavenProject;

public class AssertionsLoader {
    MavenProject project;
    File esmFile;

    public AssertionsLoader(MavenProject project) {
        this.project = project;
    }

    public AssertionsLoader(File file) {
        this.esmFile = file;
    }

    public TestSuiteDTO loadAssertions() throws Exception {
        List<File> files = this.getAssertionsFromProject();
        Map<String, List<File>> testSuiteMap = BWTestConfig.INSTANCE.getTestSuiteMap(this.project);
        TestSuiteDTO suite = new TestSuiteDTO();
        ArrayList testCaseList = new ArrayList();
        BWTestConfig.INSTANCE.getLogger().info((CharSequence)"");
        if (null != BWTestConfig.INSTANCE.getTestSuiteName() && !BWTestConfig.INSTANCE.getTestSuiteName().isEmpty()) {
            for (String suiteName : BWTestConfig.INSTANCE.getTestSuiteNameList(this.project)) {
                BWTestConfig.INSTANCE.getLogger().info((CharSequence)"");
                BWTestConfig.INSTANCE.getLogger().info((CharSequence)(" ## Running Test Suite " + suiteName + " ##"));
                for (File file : testSuiteMap.get(suiteName)) {
                    BWTestConfig.INSTANCE.getLogger().info((CharSequence)("      Running Test for " + file.getName()));
                    String assertionxml = FileUtils.readFileToString((File)file);
                    try {
                        TestFileParser.INSTANCE.collectAssertions(assertionxml, suite, this.project.getBasedir().getAbsolutePath());
                    }
                    catch (Exception e) {
                        BWTestConfig.INSTANCE.getLogger().info((CharSequence)("## ERRORS in collecting assertions  - Will skip running Test for " + file.getName() + " ##"));
                        BWTestConfig.INSTANCE.getLogger().info((CharSequence)"## Check the error indicated by following exception stack ##");
                        e.printStackTrace();
                    }
                }
            }
            return suite;
        }
        for (File file : files) {
            BWTestConfig.INSTANCE.getLogger().info((CharSequence)("## Running Test for " + file.getName() + " ##"));
            String assertionxml = FileUtils.readFileToString((File)file);
            try {
                TestFileParser.INSTANCE.collectAssertions(assertionxml, suite, this.project.getBasedir().getAbsolutePath());
            }
            catch (Exception e) {
                BWTestConfig.INSTANCE.getLogger().info((CharSequence)("## ERRORS in collecting assertions  - Will skip running Test for " + file.getName() + " ##"));
                BWTestConfig.INSTANCE.getLogger().info((CharSequence)"## Check the error indicated by following exception stack ##");
                e.printStackTrace();
            }
        }
        return suite;
    }

    public TestSuiteDTO loadAssertionsFromESM() throws Exception {
        TestSuiteDTO suite = new TestSuiteDTO();
        String filePath = this.esmFile.getAbsolutePath();
        Map<String, List<File>> testSuiteMap = BWTestConfig.INSTANCE.getEsmTestSuiteMap(filePath);
        if (null != testSuiteMap && !testSuiteMap.isEmpty()) {
            for (String suiteName : BWTestConfig.INSTANCE.getEsmTestSuiteNameList(filePath)) {
                BWTestConfig.INSTANCE.getLogger().info((CharSequence)"");
                BWTestConfig.INSTANCE.getLogger().info((CharSequence)(" ## Running Test Suite [" + suiteName + "] From ESM [" + this.esmFile.getName() + "] ##"));
                for (File file : testSuiteMap.get(suiteName)) {
                    BWTestConfig.INSTANCE.getLogger().info((CharSequence)("      Running Test for " + file.getName()));
                    String assertionxml = FileUtils.readFileToString((File)file);
                    TestFileParser.INSTANCE.collectAssertions(assertionxml, suite, filePath);
                }
            }
            return suite;
        }
        List<File> files = this.getAssertionsFromESM();
        for (File file : files) {
            BWTestConfig.INSTANCE.getLogger().info((CharSequence)"");
            BWTestConfig.INSTANCE.getLogger().info((CharSequence)("## Running Test for " + file.getName() + " ##"));
            String assertionxml = FileUtils.readFileToString((File)file);
            TestFileParser.INSTANCE.collectAssertions(assertionxml, suite, filePath);
        }
        return suite;
    }

    private List<File> getAssertionsFromProject() {
        return BWTestConfig.INSTANCE.getTestCasesList(this.project);
    }

    private List<File> getAssertionsFromESM() {
        return BWTestConfig.INSTANCE.getEsmTestCasesList(this.esmFile.getAbsolutePath());
    }
}

