/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.test.setuplocal;

import com.tibco.bw.maven.plugin.osgi.helpers.ManifestParser;
import com.tibco.bw.maven.plugin.test.helpers.BWTestConfig;
import com.tibco.bw.maven.plugin.utils.Path;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigFileGenerator {
    ArrayList<String> bundleNamesList = new ArrayList();
    Boolean isBundleToStart = false;
    MavenSession session;
    ProjectDependenciesResolver resolver;

    public ConfigFileGenerator(MavenSession session, ProjectDependenciesResolver resolver) {
        this.session = session;
        this.resolver = resolver;
    }

    public void generateConfig() {
        try {
            File configIni = new File(BWTestConfig.INSTANCE.getConfigDir(), "config.ini");
            configIni.createNewFile();
            StringBuilder builder = new StringBuilder();
            List<File> targets = this.getTargetPlatform();
            for (File target : targets) {
                this.addPluginsFromDir(target, builder);
            }
            ArrayList<MavenProject> requiredDevPropertiesProjects = new ArrayList<MavenProject>();
            List projects = BWTestConfig.INSTANCE.getSession().getProjects();
            for (MavenProject project : projects) {
                DependencyResolutionResult resolutionResult;
                if (!project.getPackaging().equals("bwmodule") && !project.getPackaging().equals("bwear")) continue;
                if (this.isJavaProject(project)) {
                    requiredDevPropertiesProjects.add(project);
                }
                if ((resolutionResult = this.getDependenciesResolutionResult(project)) == null) continue;
                boolean isCXF = false;
                for (Dependency dependency : resolutionResult.getDependencies()) {
                    if (dependency.getArtifact().getVersion().equals("0.0.0")) continue;
                    Artifact aetherArtifact = dependency.getArtifact();
                    if (!("provided".equals(dependency.getScope()) || aetherArtifact.getFile().getName().contains("com.tibco.bw.palette.shared") || aetherArtifact.getFile().getName().contains("com.tibco.xml.cxf.common") || aetherArtifact.getGroupId().equalsIgnoreCase("tempbw"))) {
                        builder.append(",");
                        this.addReference(builder, aetherArtifact.getFile(), aetherArtifact.getArtifactId());
                    }
                    if (!aetherArtifact.getFile().getName().contains("com.tibco.xml.cxf.common")) continue;
                    isCXF = true;
                }
                if (!isCXF) continue;
                requiredDevPropertiesProjects.add(project);
            }
            for (MavenProject project : projects) {
                if (!project.getPackaging().equals("bwmodule") && !project.getPackaging().equals("bwear")) continue;
                builder.append(",");
                this.addReference(builder, project.getBasedir(), project.getBasedir().getName());
            }
            Properties properties = new Properties();
            properties.put("osgi.bundles", builder.toString());
            properties.put("osgi.bundles.defaultStartLevel", "5");
            properties.put("osgi.install.area", "file:" + BWTestConfig.INSTANCE.getTibcoHome() + BWTestConfig.INSTANCE.getBwHome() + "/system/hotfix/lib/common");
            properties.put("osgi.framework", "file:" + BWTestConfig.INSTANCE.getTibcoHome() + BWTestConfig.INSTANCE.getBwHome() + "/system/lib/common/org.eclipse.osgi_3.16.200.v20210226-1447.jar");
            properties.put("osgi.configuration.cascaded", "false");
            FileOutputStream stream = new FileOutputStream(configIni);
            properties.store(stream, "Configuration File");
            stream.flush();
            stream.close();
            this.generateDevPropertiesFile(requiredDevPropertiesProjects);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private DependencyResolutionResult getDependenciesResolutionResult(MavenProject project) {
        DependencyResolutionResult resolutionResult = null;
        try {
            DefaultDependencyResolutionRequest resolution = new DefaultDependencyResolutionRequest(project, this.session.getRepositorySession());
            resolutionResult = this.resolver.resolve((DependencyResolutionRequest)resolution);
            System.out.println();
        }
        catch (DependencyResolutionException e) {
            e.printStackTrace();
            resolutionResult = e.getResult();
        }
        return resolutionResult;
    }

    private boolean isJavaProject(MavenProject project) {
        File projectFile = new File(project.getBasedir(), ".project");
        NodeList nList = this.getNatureList(projectFile);
        if (nList != null) {
            for (int i = 0; i < nList.getLength(); ++i) {
                Element node;
                String nature;
                if (nList.item(i) == null || (nature = (node = (Element)nList.item(i)).getTextContent()) == null || !nature.equals("org.eclipse.jdt.core.javanature")) continue;
                return true;
            }
        }
        return false;
    }

    private NodeList getNatureList(File dotProject) {
        NodeList nList = null;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(dotProject);
            nList = doc.getElementsByTagName("nature");
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return nList;
    }

    private void generateDevPropertiesFile(List<MavenProject> requiredDevPropertiesProjects) throws IOException, DependencyResolutionRequiredException {
        File devProps = new File(BWTestConfig.INSTANCE.getConfigDir(), "dev.properties");
        devProps.createNewFile();
        Properties properties = new Properties();
        properties.put("@ignoredot@", "true");
        for (MavenProject reqProject : requiredDevPropertiesProjects) {
            Manifest projectManifest = ManifestParser.parseManifest(reqProject.getBasedir());
            String bundleClassPath = projectManifest.getMainAttributes().getValue("Bundle-ClassPath");
            BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Bundle-Classpath for project " + reqProject.getName() + " -> " + bundleClassPath));
            Object pathString = "";
            if (bundleClassPath != null) {
                String[] pathEntries;
                for (String path : pathEntries = bundleClassPath.split(",")) {
                    if (path.equals(".")) continue;
                    pathString = (String)pathString + "," + path;
                }
            }
            pathString = "bin,target/classes" + (String)pathString;
            properties.put(reqProject.getName(), pathString);
            BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Adding project entry to dev.properties -> " + reqProject.getName() + "=" + (String)pathString));
        }
        FileOutputStream stream = new FileOutputStream(devProps);
        properties.store(stream, "dev properties");
        stream.flush();
        stream.close();
    }

    private void addPluginsFromDir(File target, StringBuilder builder) {
        File[] files;
        for (File file : files = target.listFiles()) {
            File libFolder = new File(file.getAbsolutePath().concat("/lib"));
            if (libFolder.exists() && libFolder.getAbsolutePath() != null && libFolder.getAbsolutePath().indexOf("com.tibco.bw.jdbc.datasourcefactory.datadirect") < 0 && libFolder.isDirectory() && !this.hasDBJar(libFolder) || file.getName().contains("DS_Store")) continue;
            String[] split = file.getName().split("_");
            if (this.bundleNamesList.isEmpty()) {
                this.bundleNamesList.add(split[0]);
                this.isBundleToStart = true;
            } else {
                for (String bundleName : this.bundleNamesList) {
                    if (null != bundleName && bundleName.equals(split[0])) {
                        this.isBundleToStart = false;
                        break;
                    }
                    this.isBundleToStart = true;
                }
                if (this.isBundleToStart.booleanValue()) {
                    this.bundleNamesList.add(split[0]);
                }
            }
            if (!this.isBundleToStart.booleanValue()) continue;
            if (builder.length() > 0) {
                builder.append(",");
            }
            this.addReference(builder, file, split[0]);
        }
    }

    private boolean hasDBJar(File libFolder) {
        File[] files = libFolder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
                return true;
            }
        }
        return false;
    }

    private void addReference(StringBuilder builder, File file, String key) {
        builder.append("reference:");
        builder.append("file:");
        builder.append(new Path(file.getAbsolutePath()).removeTrailingSeparator().toString());
        builder.append(this.getStartValue(key));
    }

    private List<File> getTargetPlatform() {
        File file;
        ArrayList<File> list = new ArrayList<File>();
        String[] platformDirs = new String[]{"system/hotfix/lib/common", "system/lib/common", "system/hotfix/palettes", "system/palettes", "system/hotfix/shared", "system/shared", "config/drivers/shells/jdbc.oracle.runtime/hotfix/runtime/plugins", "config/drivers/shells/jdbc.oracle.runtime/runtime/plugins", "config/drivers/shells/jdbc.mysql.runtime/hotfix/runtime/plugins", "config/drivers/shells/jdbc.mysql.runtime/runtime/plugins", "config/drivers/shells/jdbc.mariadb.runtime/hotfix/runtime/plugins", "config/drivers/shells/jdbc.mariadb.runtime/runtime/plugins", "config/drivers/shells/jdbc.db2.runtime/hotfix/runtime/plugins", "config/drivers/shells/jdbc.db2.runtime/runtime/plugins"};
        String bwHomeStr = BWTestConfig.INSTANCE.getTibcoHome() + BWTestConfig.INSTANCE.getBwHome();
        File pluginPalettes = BWTestConfig.INSTANCE.getBwHome().contains("bwce") ? new File(BWTestConfig.INSTANCE.getTibcoHome().concat("/bwce/palettes")) : new File(BWTestConfig.INSTANCE.getTibcoHome().concat("/bw/palettes"));
        if (pluginPalettes.exists() && pluginPalettes.isDirectory()) {
            java.nio.file.Path[] pluginPlatformDirs = this.getPluginPlatformDir(pluginPalettes.getPath());
            for (java.nio.file.Path pluginFile : pluginPlatformDirs) {
                file = new File(pluginFile.toString(), "plugins");
                if (!file.exists()) continue;
                list.add(file);
            }
        }
        File bwHome = new File(bwHomeStr);
        for (String str : platformDirs) {
            file = new File(bwHome, str);
            if (!file.exists()) continue;
            list.add(file);
        }
        return list;
    }

    private java.nio.file.Path[] getPluginPlatformDir(String path) {
        java.nio.file.Path[] pathArray;
        block8: {
            Stream<java.nio.file.Path> paths = Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]);
            try {
                java.nio.file.Path[] pluginDirPath;
                pathArray = pluginDirPath = (java.nio.file.Path[])paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(s -> s.endsWith("runtime")).toArray(java.nio.file.Path[]::new);
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            paths.close();
        }
        return pathArray;
    }

    private Map<String, String> getStartValuesMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("com.tibco.tpcl.javax.system.exports", "");
        map.put("com.tibco.bw.extensions.logback", "");
        map.put("com.tibco.bw.thor.equinox.env", "");
        map.put("com.tibco.neo.eclipse.support.osgi", "@3:start");
        map.put("org.eclipse.osgi.compatibility.state", "");
        map.put("com.tibco.bw.thor.runtime.tools", "@2:start");
        map.put("com.tibco.tpcl.javax.osgi.factories", "@1:start");
        map.put("org.eclipse.equinox.common", "@2:start");
        map.put("com.tibco.tpcl.javax.system.exports.sun", "");
        map.put("org.eclipse.equinox.console.jaas.fragment", "");
        return map;
    }

    private String getStartValue(String key) {
        Map<String, String> map = this.getStartValuesMap();
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return "@start";
    }
}

