/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.testsuite;

import com.tibco.bw.maven.plugin.test.helpers.BWTestConfig;
import com.tibco.bw.maven.plugin.testsuite.BWTSFileReaderWrapper;
import com.tibco.bw.maven.plugin.utils.BWFileUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BWTestSuiteLoader {
    private String testFolderName = null;

    public List<File> collectTestCasesList(String baseDir, MavenProject project) throws IOException {
        ArrayList<File> testSuitefile = new ArrayList();
        ArrayList<String> testSuiteNamePathList = new ArrayList<String>();
        ArrayList<String> testSuiteNameList = new ArrayList<String>();
        String testFolderPath = "";
        File[] fileList = this.getFileList(baseDir);
        String contents = FileUtils.readFileToString((File)fileList[0]);
        if (contents != null) {
            this.testFolderName = BWTestSuiteLoader.readProperties(contents, fileList[0]);
        }
        for (String testSuiteName : BWTestConfig.INSTANCE.getUserTestSuiteNames().keySet()) {
            String folderPath = BWFileUtils.getTestFolderName(baseDir.toString(), testSuiteName, this.testFolderName);
            if (null != folderPath) {
                testFolderPath = folderPath;
                String[] finalTestSuiteName = null;
                if (testSuiteName.contains(File.separator)) {
                    finalTestSuiteName = testSuiteName.split(Pattern.quote(File.separator));
                }
                if (finalTestSuiteName != null) {
                    testSuiteNamePathList.add(StringUtils.substringBefore((String)folderPath, (String)(File.separator + finalTestSuiteName[0])).concat("//" + testSuiteName));
                    testSuiteNameList.add(testSuiteName);
                } else {
                    testSuiteNamePathList.add(folderPath.concat("//" + testSuiteName));
                    testSuiteNameList.add(testSuiteName);
                }
                BWTestConfig.INSTANCE.getUserTestSuiteNames().replace(testSuiteName, true);
                continue;
            }
            BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Test Suite file " + testSuiteName + " is not found at " + baseDir));
        }
        BWTestConfig.INSTANCE.setTestSuiteNameList(project, testSuiteNameList);
        BWTSFileReaderWrapper fileReader = new BWTSFileReaderWrapper();
        testSuitefile = fileReader.readBWTSFile(testSuiteNamePathList, testFolderPath, project, this.testFolderName);
        return testSuitefile;
    }

    private File[] getFileList(String baseDir) {
        File dir = new File(baseDir);
        File[] fileList = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".config");
            }
        });
        return fileList;
    }

    protected static String readProperties(String contents, File propsFile) {
        ByteArrayInputStream is = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            is = new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));
            Document document = builder.parse(is);
            NodeList nodeList = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || !"config:specialFolders".equals((el = (Element)node).getNodeName())) continue;
                NodeList childNodes = el.getChildNodes();
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    Element cEl;
                    Node cNode = childNodes.item(j);
                    if (!(cNode instanceof Element) || !"config:folder".equals((cEl = (Element)cNode).getNodeName()) || !cNode.getAttributes().getNamedItem("kind").getNodeValue().equals("bwtf")) continue;
                    return cNode.getAttributes().getNamedItem("location").getNodeValue();
                }
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<File> collectTestCasesListFromESM(String baseDir) throws IOException {
        ArrayList<File> testSuitefile = new ArrayList();
        ArrayList<String> testSuiteNamePathList = new ArrayList<String>();
        ArrayList<String> testSuiteNameList = new ArrayList<String>();
        String testFolderPath = "";
        for (String testSuiteName : BWTestConfig.INSTANCE.getUserESMTestSuiteNames().keySet()) {
            String folderPath;
            File[] fileList;
            String contents;
            if (this.testFolderName == null && (contents = FileUtils.readFileToString((File)(fileList = this.getFileList(baseDir))[0])) != null) {
                this.testFolderName = BWTestSuiteLoader.readProperties(contents, fileList[0]);
            }
            if (null != (folderPath = BWFileUtils.getTestFolderName(baseDir, testSuiteName, this.testFolderName))) {
                testFolderPath = folderPath;
                testSuiteNamePathList.add(folderPath.concat("//" + testSuiteName));
                testSuiteNameList.add(testSuiteName);
                BWTestConfig.INSTANCE.getUserTestSuiteNames().replace(testSuiteName, true);
                continue;
            }
            BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Test Suite file " + testSuiteName + " is not found at " + baseDir));
        }
        BWTestConfig.INSTANCE.setEsmTestSuiteNameList(baseDir, testSuiteNameList);
        BWTSFileReaderWrapper fileReader = new BWTSFileReaderWrapper();
        testSuitefile = fileReader.readBWTSFileFromESM(testSuiteNamePathList, testFolderPath, baseDir);
        return testSuitefile;
    }
}

