/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.test.coverage;

import com.tibco.bw.maven.plugin.test.coverage.ProcessCoverage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProcessCoverageStatsGenerator {
    private static DecimalFormat format = new DecimalFormat("#.##");
    private OverAllStats stats = new OverAllStats();
    private List<ProcessStats> processStats = new ArrayList<ProcessStats>();

    public void generateStats(Map<String, ProcessCoverage> map) {
        for (ProcessCoverage cov : map.values()) {
            this.stats.addModule(cov.getModuleName());
            this.stats.addProcess(cov.getProcessName());
            if (cov.isProcessExecuted()) {
                this.stats.addModuleCovered(cov.getModuleName());
                this.stats.addProcessCovered(cov.getProcessName());
            }
            this.stats.addActivities(cov.getActivities().size());
            this.stats.addActivitiesCovered(cov.getActivitiesExec().size());
            this.stats.addTransition(cov.getTransitions().size());
            this.stats.addTransitionCovered(cov.getTransitionExec().size());
            ProcessStats pstat = new ProcessStats();
            pstat.setModuleName(cov.getModuleName());
            pstat.setProcessName(cov.getProcessName());
            pstat.setTotalActivities(cov.getActivities().size());
            pstat.setCoveredActivities(cov.getActivitiesExec().size());
            pstat.setTotalTransitions(cov.getTransitions().size());
            pstat.setCoveredTransitions(cov.getTransitionExec().size());
            this.processStats.add(pstat);
        }
    }

    public OverAllStats getStats() {
        return this.stats;
    }

    public List<ProcessStats> getProcessStats() {
        return this.processStats;
    }

    public static class ProcessStats {
        private String processName;
        private String moduleName;
        private int totalTransitions;
        private int totalActivities;
        private int coveredTransitions;
        private int coveredActivities;

        public String getActivityStat() {
            int total = this.totalActivities;
            int covered = this.coveredActivities;
            float success = 0.0f;
            success = total == covered ? 100.0f : (covered == 0 ? 0.0f : (float)covered / (float)total * 100.0f);
            return format.format(success) + "%  (" + covered + " / " + total + ")";
        }

        public String getTransitionStat() {
            int total = this.totalTransitions;
            int covered = this.coveredTransitions;
            float success = 0.0f;
            success = total == covered ? 100.0f : (covered == 0 ? 0.0f : (float)covered / (float)total * 100.0f);
            return format.format(success) + "%  (" + covered + " / " + total + ")";
        }

        public String getProcessName() {
            return this.processName;
        }

        public void setProcessName(String processName) {
            this.processName = processName;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public void setModuleName(String moduleName) {
            this.moduleName = moduleName;
        }

        public int getTotalTransitions() {
            return this.totalTransitions;
        }

        public void setTotalTransitions(int totalTransitions) {
            this.totalTransitions = totalTransitions;
        }

        public int getTotalActivities() {
            return this.totalActivities;
        }

        public void setTotalActivities(int totalActivities) {
            this.totalActivities = totalActivities;
        }

        public int getCoveredTransitions() {
            return this.coveredTransitions;
        }

        public void setCoveredTransitions(int coveredTransitions) {
            this.coveredTransitions = coveredTransitions;
        }

        public int getCoveredActivities() {
            return this.coveredActivities;
        }

        public void setCoveredActivities(int coveredActivities) {
            this.coveredActivities = coveredActivities;
        }
    }

    public static class OverAllStats {
        private Set<String> totalModules = new HashSet<String>();
        private Set<String> coveredModules = new HashSet<String>();
        private Set<String> totalProcess = new HashSet<String>();
        private Set<String> coveredProcess = new HashSet<String>();
        private int totalTransitions;
        private int totalActivities;
        private int coveredTransitions;
        private int coveredActivities;

        public void addModule(String module) {
            this.totalModules.add(module);
        }

        public void addModuleCovered(String module) {
            this.coveredModules.add(module);
        }

        public void addProcess(String process) {
            this.totalProcess.add(process);
        }

        public void addProcessCovered(String process) {
            this.coveredProcess.add(process);
        }

        public void addActivities(int count) {
            this.totalActivities += count;
        }

        public void addActivitiesCovered(int count) {
            this.coveredActivities += count;
        }

        public void addTransition(int count) {
            this.totalTransitions += count;
        }

        public void addTransitionCovered(int count) {
            this.coveredTransitions += count;
        }

        public String getModuleStat() {
            int total = this.totalModules.size();
            int covered = this.coveredModules.size();
            float success = 0.0f;
            success = total == covered ? 100.0f : (covered == 0 ? 0.0f : (float)covered / (float)total * 100.0f);
            return format.format(success) + "%  (" + covered + " / " + total + ")";
        }

        public String getProcessStat() {
            int total = this.totalProcess.size();
            int covered = this.coveredProcess.size();
            float success = 0.0f;
            success = total == covered ? 100.0f : (covered == 0 ? 0.0f : (float)covered / (float)total * 100.0f);
            return format.format(success) + "%  (" + covered + " / " + total + ")";
        }

        public String getActivityStat() {
            int total = this.totalActivities;
            int covered = this.coveredActivities;
            float success = 0.0f;
            success = total == covered ? 100.0f : (covered == 0 ? 0.0f : (float)covered / (float)total * 100.0f);
            return format.format(success) + "%  (" + covered + " / " + total + ")";
        }

        public String getTransitionStat() {
            int total = this.totalTransitions;
            int covered = this.coveredTransitions;
            float success = 0.0f;
            success = total == covered ? 100.0f : (covered == 0 ? 0.0f : (float)covered / (float)total * 100.0f);
            return format.format(success) + "%  (" + covered + " / " + total + ")";
        }
    }
}

