/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.test.report;

import com.tibco.bw.maven.plugin.test.dto.AssertionResultDTO;
import com.tibco.bw.maven.plugin.test.dto.CompleteReportDTO;
import com.tibco.bw.maven.plugin.test.dto.TestCaseResultDTO;
import com.tibco.bw.maven.plugin.test.dto.TestSetResultDTO;
import com.tibco.bw.maven.plugin.test.dto.TestSuiteResultDTO;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BWTestSuiteReportParser {
    private static DecimalFormat format = new DecimalFormat("#.##");
    private CompleteReportDTO completeResult;
    private Summary summary;
    private Map<String, PackageTestDetails> packageMap = new HashMap<String, PackageTestDetails>();

    public BWTestSuiteReportParser(CompleteReportDTO result) {
        this.completeResult = result;
        this.summary = new Summary();
        this.parse();
    }

    public Map<String, PackageTestDetails> getPackageMap() {
        return this.packageMap;
    }

    public void setPackageMap(Map<String, PackageTestDetails> packageMap) {
        this.packageMap = packageMap;
    }

    private void parse() {
        for (int count = 0; count < this.completeResult.getModuleResult().size(); ++count) {
            TestSuiteResultDTO result = (TestSuiteResultDTO)this.completeResult.getModuleResult().get(count);
            for (int i = 0; i < result.getTestSetResult().size(); ++i) {
                TestSetResultDTO testset = (TestSetResultDTO)result.getTestSetResult().get(i);
                String testPackage = testset.getPackageName();
                PackageTestDetails packageDetails = null;
                if (this.packageMap.containsKey(testPackage)) {
                    packageDetails = this.packageMap.get(testPackage);
                } else {
                    packageDetails = new PackageTestDetails();
                    packageDetails.setModuleName(result.getModuleInfo().getModuleName());
                    packageDetails.setPackageName(testPackage);
                    this.packageMap.put(testPackage, packageDetails);
                }
                ProcessTestDetails processDetails = null;
                for (ProcessTestDetails tempProcess : packageDetails.getProcessDetails()) {
                    if (!tempProcess.getProcessName().equals(testset.getProcessName())) continue;
                    processDetails = tempProcess;
                    break;
                }
                if (processDetails == null) {
                    processDetails = new ProcessTestDetails();
                    processDetails.setProcessName(testset.getProcessName());
                    packageDetails.getProcessDetails().add(processDetails);
                }
                for (int j = 0; j < testset.getTestCaseResult().size(); ++j) {
                    TestCaseResultDTO testcase = (TestCaseResultDTO)testset.getTestCaseResult().get(j);
                    ProcessFileTestDetails fileDetails = new ProcessFileTestDetails();
                    fileDetails.setFileName(testcase.getTestCaseFile());
                    fileDetails.setTotalAssertions(testcase.getAssertionsRun());
                    processDetails.getFileTestDetails().add(fileDetails);
                    for (int assercount = 0; assercount < testcase.getAssertionResult().size(); ++assercount) {
                        AssertionResultDTO aresult = (AssertionResultDTO)testcase.getAssertionResult().get(assercount);
                        if (!aresult.getAssertionStatus().equals("failed")) continue;
                        fileDetails.addAssertionFailure(aresult.getActivityName());
                    }
                    processDetails.incrementTotalTests();
                    packageDetails.incrementTotalTests();
                    if (testcase.getAssertionFailure() > 0) {
                        processDetails.incrementFailures();
                        packageDetails.incrementFailures();
                        fileDetails.incrementFailures();
                        continue;
                    }
                    if (testcase.getProcessFailures() <= 0) continue;
                    processDetails.incrementErrors();
                    packageDetails.incrementErrors();
                    fileDetails.incrementErrors();
                }
            }
        }
    }

    public Summary getSummary() {
        return this.summary;
    }

    public void setSummary(Summary summary) {
        this.summary = summary;
    }

    public class Packages {
    }

    public class Summary {
        public String getTotalTests() {
            int totaltests = 0;
            for (int count = 0; count < BWTestSuiteReportParser.this.completeResult.getModuleResult().size(); ++count) {
                TestSuiteResultDTO result = (TestSuiteResultDTO)BWTestSuiteReportParser.this.completeResult.getModuleResult().get(count);
                for (int i = 0; i < result.getTestSetResult().size(); ++i) {
                    totaltests += ((TestSetResultDTO)result.getTestSetResult().get(i)).getTestCaseResult().size();
                }
            }
            return String.valueOf(totaltests);
        }

        public String getErrors() {
            int totalErrors = 0;
            for (int count = 0; count < BWTestSuiteReportParser.this.completeResult.getModuleResult().size(); ++count) {
                TestSuiteResultDTO result = (TestSuiteResultDTO)BWTestSuiteReportParser.this.completeResult.getModuleResult().get(count);
                for (int i = 0; i < result.getTestSetResult().size(); ++i) {
                    TestSetResultDTO testset = (TestSetResultDTO)result.getTestSetResult().get(i);
                    for (int j = 0; j < testset.getTestCaseResult().size(); ++j) {
                        TestCaseResultDTO testcase = (TestCaseResultDTO)testset.getTestCaseResult().get(j);
                        if (testcase.getProcessFailures() <= 0) continue;
                        ++totalErrors;
                    }
                }
            }
            return String.valueOf(totalErrors);
        }

        public String getSkipped() {
            return "0";
        }

        public String getFailures() {
            int totalfailure = 0;
            for (int count = 0; count < BWTestSuiteReportParser.this.completeResult.getModuleResult().size(); ++count) {
                TestSuiteResultDTO result = (TestSuiteResultDTO)BWTestSuiteReportParser.this.completeResult.getModuleResult().get(count);
                for (int i = 0; i < result.getTestSetResult().size(); ++i) {
                    TestSetResultDTO testset = (TestSetResultDTO)result.getTestSetResult().get(i);
                    for (int j = 0; j < testset.getTestCaseResult().size(); ++j) {
                        TestCaseResultDTO testcase = (TestCaseResultDTO)testset.getTestCaseResult().get(j);
                        if (testcase.getAssertionFailure() <= 0) continue;
                        ++totalfailure;
                    }
                }
            }
            return String.valueOf(totalfailure);
        }

        public String getPercentage() {
            float success = 0.0f;
            success = Integer.valueOf(this.getFailures()) == 0 && Integer.valueOf(this.getErrors()) == 0 ? 100.0f : (Integer.valueOf(this.getFailures()) == Integer.valueOf(this.getTotalTests()) ? 0.0f : (Integer.valueOf(this.getErrors()) == Integer.valueOf(this.getTotalTests()) ? 0.0f : (float)(Integer.valueOf(this.getTotalTests()) - Integer.valueOf(this.getFailures()) - Integer.valueOf(this.getErrors())) / (float)Integer.valueOf(this.getTotalTests()).intValue() * 100.0f));
            return String.valueOf(format.format(success));
        }
    }

    public class ProcessFileTestDetails {
        private String fileName;
        private int totalAssertions;
        private int failures;
        private int errors;
        private List<String> assertionFailures = new ArrayList<String>();

        public ProcessFileTestDetails() {
        }

        public ProcessFileTestDetails(String fileName, int totalAssertions) {
            this.fileName = fileName;
            this.totalAssertions = totalAssertions;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public int getTotalAssertions() {
            return this.totalAssertions;
        }

        public void setTotalAssertions(int totalAssertions) {
            this.totalAssertions = totalAssertions;
        }

        public int getFailures() {
            return this.failures;
        }

        public int getErrors() {
            return this.errors;
        }

        public void incrementFailures() {
            ++this.failures;
        }

        public void incrementErrors() {
            ++this.errors;
        }

        public List<String> getAssertionFailures() {
            return this.assertionFailures;
        }

        public void setAssertionFailures(List<String> assertionFailures) {
            this.assertionFailures = assertionFailures;
        }

        public void addAssertionFailure(String str) {
            this.assertionFailures.add(str);
        }
    }

    public class ProcessTestDetails {
        private String processName;
        private int totalTests;
        private int errors;
        private int failures;
        private int skipped;
        private List<ProcessFileTestDetails> fileTestDetails = new ArrayList<ProcessFileTestDetails>();

        public ProcessTestDetails() {
        }

        public ProcessTestDetails(String processName, int totalTests, int errors, int failures, int skipped) {
            this.processName = processName;
            this.totalTests = totalTests;
            this.errors = errors;
            this.failures = failures;
            this.skipped = skipped;
        }

        public String getProcessName() {
            return this.processName;
        }

        public void setProcessName(String processName) {
            this.processName = processName;
        }

        public int getTotalTests() {
            return this.totalTests;
        }

        public void incrementTotalTests() {
            ++this.totalTests;
        }

        public int getErrors() {
            return this.errors;
        }

        public void incrementErrors() {
            ++this.errors;
        }

        public int getFailures() {
            return this.failures;
        }

        public void incrementFailures() {
            ++this.failures;
        }

        public int getSkipped() {
            return this.skipped;
        }

        public void incrementSkipped() {
            ++this.skipped;
        }

        public String getSuccessRate() {
            float success = 0.0f;
            success = this.failures == 0 && this.errors == 0 ? 100.0f : (this.errors == this.totalTests ? 0.0f : (this.failures == this.totalTests ? 0.0f : (float)(this.totalTests - this.failures - this.errors) / (float)this.totalTests * 100.0f));
            return String.valueOf(format.format(success));
        }

        public List<ProcessFileTestDetails> getFileTestDetails() {
            return this.fileTestDetails;
        }

        public void setFileTestDetails(List<ProcessFileTestDetails> fileTestDetails) {
            this.fileTestDetails = fileTestDetails;
        }
    }

    public class PackageTestDetails {
        private String moduleName;
        private String packageName;
        private int totalTests;
        private int errors;
        private int failures;
        private int skipped;
        private List<ProcessTestDetails> processDetails = new ArrayList<ProcessTestDetails>();

        public String getPackageName() {
            return this.packageName;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public void setModuleName(String moduleName) {
            this.moduleName = moduleName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public int getTotalTests() {
            return this.totalTests;
        }

        public void incrementTotalTests() {
            ++this.totalTests;
        }

        public int getErrors() {
            return this.errors;
        }

        public void incrementErrors() {
            ++this.errors;
        }

        public int getFailures() {
            return this.failures;
        }

        public void incrementFailures() {
            ++this.failures;
        }

        public int getSkipped() {
            return this.skipped;
        }

        public void incrementSkipped() {
            ++this.skipped;
        }

        public String getSuccessRate() {
            float success = 0.0f;
            success = this.failures == 0 && this.errors == 0 ? 100.0f : (this.errors == this.totalTests ? 0.0f : (this.failures == this.totalTests ? 0.0f : (float)(this.totalTests - this.failures - this.errors) / (float)this.totalTests * 100.0f));
            return String.valueOf(format.format(success));
        }

        public List<ProcessTestDetails> getProcessDetails() {
            return this.processDetails;
        }

        public void setProcessDetails(List<ProcessTestDetails> map) {
            this.processDetails = map;
        }
    }
}

