/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.test.setuplocal;

import com.tibco.bw.maven.plugin.test.helpers.BWTestConfig;
import com.tibco.bw.maven.plugin.test.helpers.TestFileParser;
import com.tibco.bw.maven.plugin.test.rest.BWTestRunner;
import com.tibco.bw.maven.plugin.test.setuplocal.ConfigFileGenerator;
import com.tibco.bw.maven.plugin.test.setuplocal.EngineLaunchConfigurator;
import com.tibco.bw.maven.plugin.test.setuplocal.EngineRunner;
import com.tibco.bw.maven.plugin.utils.BWFileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class BWTestExecutor {
    public static BWTestExecutor INSTANCE = new BWTestExecutor();
    int engineDebugPort;
    List<String> mockActivity = new ArrayList<String>();

    public void execute() throws MojoFailureException, Exception {
        try {
            this.initialize();
            this.runEngine();
            this.runTests();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (BWTestConfig.INSTANCE.getEngineProcess() != null) {
                BWTestConfig.INSTANCE.getEngineProcess().destroyForcibly();
            }
            if (BWTestConfig.INSTANCE.getConfigDir() != null) {
                BWTestConfig.INSTANCE.getConfigDir().delete();
            }
        }
    }

    public void collectSkipInitActivityName() throws Exception, FileNotFoundException {
        List projects = BWTestConfig.INSTANCE.getSession().getProjects();
        for (MavenProject project : projects) {
            if (!project.getPackaging().equals("bwmodule")) continue;
            File baseDir = project.getBasedir();
            List<File> files = BWFileUtils.getEntitiesfromLocation(baseDir.toString(), "bwt");
            for (File file : files) {
                HashSet<Object> tempSkipSet = new HashSet();
                String assertionxml = FileUtils.readFileToString((File)file);
                tempSkipSet = TestFileParser.INSTANCE.collectSkipInitActivities(assertionxml);
                if (tempSkipSet.isEmpty()) continue;
                this.mockActivity.addAll(tempSkipSet);
                INSTANCE.setMockActivityList(this.mockActivity);
            }
        }
    }

    private void initialize() throws Exception {
        this.collectSkipInitActivityName();
        EngineLaunchConfigurator config = new EngineLaunchConfigurator();
        config.loadConfiguration();
        ConfigFileGenerator gen = new ConfigFileGenerator();
        gen.generateConfig();
    }

    private void runEngine() throws Exception {
        EngineRunner runner = new EngineRunner();
        runner.run();
    }

    private void runTests() throws MojoFailureException, Exception {
        BWTestRunner runner = new BWTestRunner("localhost", INSTANCE.getEngineDebugPort());
        runner.runTests();
    }

    public void setEngineDebugPort(int engineDebugPort) {
        this.engineDebugPort = engineDebugPort;
    }

    public int getEngineDebugPort() {
        return this.engineDebugPort;
    }

    public List<String> getMockActivityList() {
        return this.mockActivity;
    }

    public void setMockActivityList(List<String> mockActivity) {
        this.mockActivity = mockActivity;
    }
}

