/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.admin.client;

import com.tibco.bw.maven.plugin.admin.client.ClientException;
import com.tibco.bw.maven.plugin.admin.dto.Agent;
import com.tibco.bw.maven.plugin.admin.dto.AppNode;
import com.tibco.bw.maven.plugin.admin.dto.AppSpace;
import com.tibco.bw.maven.plugin.admin.dto.Application;
import com.tibco.bw.maven.plugin.admin.dto.Archive;
import com.tibco.bw.maven.plugin.admin.dto.Domain;
import com.tibco.bw.maven.plugin.admin.dto.Error;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.logging.Log;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;

public class RemoteDeployer {
    private static final String DATE_TIME = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
    private static final String CONTEXT_ROOT = "/bw/v1";
    private Client jerseyClient;
    private WebTarget r;
    private String scheme = "http";
    private final String host;
    private final int port;
    private final String agentAuth;
    private final boolean agentSSL;
    private final String username;
    private final String password;
    private final String trustPath;
    private final String trustPassword;
    private final String keyPath;
    private final String keyPassword;
    private Log log;

    public RemoteDeployer(String host, int port, String agentAuthType, String username, String password, boolean agentSSL, String trustFilePath, String trustPassword, String keyFilePath, String keyPassword) {
        this.host = host;
        this.port = port;
        this.agentAuth = agentAuthType;
        this.username = username;
        this.password = password;
        this.agentSSL = agentSSL;
        this.trustPath = trustFilePath;
        this.trustPassword = trustPassword;
        this.keyPath = keyFilePath;
        this.keyPassword = keyPassword;
    }

    private void init() {
        if (this.jerseyClient == null) {
            HttpAuthenticationFeature feature;
            ClientConfig clientConfig = new ClientConfig();
            clientConfig.register(JacksonFeature.class).register(MultiPartFeature.class);
            if (this.agentSSL) {
                this.scheme = "https";
                SslConfigurator sslConfig = this.keyPath != null && !this.keyPath.isEmpty() && this.keyPassword != null && !this.keyPassword.isEmpty() ? SslConfigurator.newInstance().trustStoreFile(this.trustPath).trustStorePassword(this.trustPassword).keyStoreFile(this.keyPath).keyPassword(this.keyPassword) : SslConfigurator.newInstance().trustStoreFile(this.trustPath).trustStorePassword(this.trustPassword);
                this.jerseyClient = ClientBuilder.newBuilder().withConfig((Configuration)clientConfig).sslContext(sslConfig.createSSLContext()).hostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                }).build();
            } else {
                this.jerseyClient = ClientBuilder.newClient((Configuration)clientConfig);
            }
            if (this.agentAuth != null && "BASIC".equalsIgnoreCase(this.agentAuth)) {
                feature = HttpAuthenticationFeature.basic((String)this.username, (String)this.password);
                this.jerseyClient.register((Object)feature);
            } else if (this.agentAuth != null && "DIGEST".equalsIgnoreCase(this.agentAuth)) {
                feature = HttpAuthenticationFeature.digest((String)this.username, (String)this.password);
                this.jerseyClient.register((Object)feature);
            }
        }
        this.r = this.jerseyClient.target(UriBuilder.fromPath((String)CONTEXT_ROOT).scheme(this.scheme).host(this.host).port(this.port).build(new Object[0]));
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void close() {
        if (this.jerseyClient != null) {
            this.jerseyClient.close();
            this.jerseyClient = null;
        }
    }

    public List<Agent> getAgentInfo() throws ClientException {
        this.init();
        try {
            Response response = this.r.path("/agents").path("info").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
            this.processErrorResponse(response);
            List info = (List)response.readEntity((GenericType)new GenericType<List<Agent>>(){});
            return info;
        }
        catch (ProcessingException pe) {
            throw RemoteDeployer.getConnectionException(pe);
        }
        catch (Exception ex) {
            throw new ClientException(500, ex.getMessage(), ex);
        }
    }

    public Domain getOrCreateDomain(String name, String desc) throws ClientException {
        List<Domain> domains = this.getDomains(null, false, true);
        for (Domain domain : domains) {
            if (!domain.getName().equals(name)) continue;
            this.log.info((CharSequence)("Domain exists with Name -> " + name));
            return domain;
        }
        this.log.info((CharSequence)("Creating Domain with name -> " + name));
        return this.createDomain(name, desc, "owner", null, null);
    }

    private Domain createDomain(String name, String description, String owner, String agent, String home) throws ClientException {
        this.init();
        try {
            this.addQueryParam("desc", description);
            this.addQueryParam("agent", agent);
            this.addQueryParam("owner", owner);
            this.addQueryParam("home", home);
            Response response = this.r.path("/domains").path(name).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(null);
            this.processErrorResponse(response);
            Domain domain = (Domain)response.readEntity(Domain.class);
            return domain;
        }
        catch (ProcessingException pe) {
            throw RemoteDeployer.getConnectionException(pe);
        }
        catch (Exception ex) {
            throw new ClientException(500, ex.getMessage(), ex);
        }
    }

    private List<Domain> getDomains(String filter, boolean full, boolean status) throws ClientException {
        this.init();
        try {
            this.r = this.r.queryParam("full", new Object[]{full}).queryParam("status", new Object[]{status});
            this.addQueryParam("filter", filter);
            Response response = this.r.path("/browse").path("domains").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
            this.processErrorResponse(response);
            List domains = (List)response.readEntity((GenericType)new GenericType<List<Domain>>(){});
            return domains;
        }
        catch (ProcessingException pe) {
            throw RemoteDeployer.getConnectionException(pe);
        }
        catch (Exception ex) {
            throw new ClientException(500, ex.getMessage(), ex);
        }
    }

    private AppSpace setProfile(String domainName, String appSpaceName, String version, String appName, String externalProfileLoc) throws ClientException {
        this.init();
        try {
            FileDataBodyPart filePart = new FileDataBodyPart("file", new File(externalProfileLoc));
            FormDataMultiPart formDataMultiPart = new FormDataMultiPart();
            FormDataMultiPart multipart = (FormDataMultiPart)formDataMultiPart.bodyPart((BodyPart)filePart);
            MediaType contentType = formDataMultiPart.getMediaType();
            Response response = this.r.path("/domains").path(domainName).path("appspaces").path(appSpaceName).path("applications").path(appName).path(version).path("config").path("externalprofile").request().put(Entity.entity((Object)multipart, (MediaType)contentType));
            this.processErrorResponse(response);
            AppSpace appSpace = (AppSpace)response.readEntity(AppSpace.class);
            return appSpace;
        }
        catch (ProcessingException pe) {
            throw RemoteDeployer.getConnectionException(pe);
        }
        catch (Exception ex) {
            throw new ClientException(500, ex.getMessage(), ex);
        }
    }

    public AppSpace getOrCreateAppSpace(String domainName, String appSpaceName, String desc) throws ClientException {
        List<AppSpace> appSpaces = this.getAppSpaces(domainName, null, false, true);
        for (AppSpace appSpace : appSpaces) {
            if (!appSpace.getName().equals(appSpaceName)) continue;
            this.log.info((CharSequence)("AppSpace exists with Name -> " + appSpaceName + " in Domain -> " + domainName));
            return appSpace;
        }
        this.log.info((CharSequence)("Creating AppSpace with Name -> " + appSpaceName + " in Domain -> " + domainName));
        return this.createAppSpace(domainName, appSpaceName, true, 0, null, desc, "owner");
    }

    public AppNode getOrCreateAppNode(String domainName, String appSpaceName, String appNodeName, int httpPort, int osgiPort, String description, String agentName) throws ClientException {
        List<AppNode> nodes = this.getAppNodes(domainName, appSpaceName, null, true);
        for (AppNode node : nodes) {
            if (!node.getName().equals(appNodeName)) continue;
            this.log.info((CharSequence)("AppNode exists with Name -> " + appNodeName + " in Domain -> " + domainName + " and in AppSpace -> " + appSpaceName));
            this.log.info((CharSequence)("AppNode HTTP Port  -> " + httpPort + ". AppNode OSGi Port -> " + osgiPort));
            return node;
        }
        this.log.info((CharSequence)("Creating AppNode with Name -> " + appNodeName + " in Domain -> " + domainName + " and in AppSpace -> " + appSpaceName));
        return this.createAppNode(domainName, appSpaceName, appNodeName, agentName, httpPort, osgiPort, description);
    }

    public void addAndDeployApplication(String domainName, String appSpaceName, String appName, String earName, String file, boolean replace, String profile, boolean backupEar, String backupLocation, String version, boolean externalProfile, String externalProfileLoc) throws ClientException {
        List<Application> applications = this.getApplications(domainName, appSpaceName, null, true);
        for (Application application : applications) {
            if (!application.getName().equals(appName)) continue;
            if (replace) {
                if (backupEar) {
                    this.log.info((CharSequence)("Generating backup ear file for application -> " + appName));
                    this.downloadArchive(domainName, backupLocation, application.getArchiveName().toString());
                    this.log.info((CharSequence)("Generating backup substvar file for profile -> " + application.getProfileName()));
                    this.downloadProfileAplication(domainName, backupLocation, application.getArchiveName().toString(), application.getProfileName());
                }
                this.log.info((CharSequence)("Application exists with name -> " + appName + ". Undeploying the Application as Redeploy flag is true."));
                this.undeployApplication(domainName, appSpaceName, appName, application.getVersion());
                continue;
            }
            this.log.info((CharSequence)("Application exists with name -> " + appName + ". Not Re-deploying the Application as Redeploy flag is false."));
            return;
        }
        this.log.info((CharSequence)("Uploading the Archive file -> " + earName));
        this.uploadArchive(domainName, null, file, true);
        this.log.info((CharSequence)("Deploying the Application with name -> " + appName + " with Profile -> " + profile));
        this.deployApplication(domainName, appSpaceName, earName, null, true, replace, profile, externalProfile);
        if (externalProfile) {
            this.setProfile(domainName, appSpaceName, version, appName, externalProfileLoc);
        }
    }

    private List<AppSpace> getAppSpaces(String domainName, String filter, boolean full, boolean status) throws ClientException {
        this.init();
        try {
            this.addQueryParam("domain", domainName);
            this.r = this.r.queryParam("full", new Object[]{full}).queryParam("status", new Object[]{status});
            this.addQueryParam("filter", filter);
            Response response = this.r.path("/browse").path("appspaces").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
            this.processErrorResponse(response);
            List appSpaces = (List)response.readEntity((GenericType)new GenericType<List<AppSpace>>(){});
            return appSpaces;
        }
        catch (ProcessingException pe) {
            throw RemoteDeployer.getConnectionException(pe);
        }
        catch (Exception ex) {
            throw new ClientException(500, ex.getMessage(), ex);
        }
    }

    private AppSpace createAppSpace(String domainName, String appSpaceName, boolean elastic, int minNodes, String version, String description, String owner) throws ClientException {
        this.init();
        try {
            this.r = this.r.queryParam("elastic", new Object[]{String.valueOf(elastic)}).queryParam("minNodes", new Object[]{String.valueOf(minNodes)});
            this.addQueryParam("version", version);
            this.addQueryParam("desc", description);
            this.addQueryParam("owner", owner);
            Response response = this.r.path("/domains").path(domainName).path("appspaces").path(appSpaceName).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(null);
            this.processErrorResponse(response);
            AppSpace appSpace = (AppSpace)response.readEntity(AppSpace.class);
            return appSpace;
        }
        catch (ProcessingException pe) {
            throw RemoteDeployer.getConnectionException(pe);
        }
        catch (Exception ex) {
            throw new ClientException(500, ex.getMessage(), ex);
        }
    }

    public void startAppSpace(String domainName, String appSpaceName) throws ClientException {
        this.init();
        this.log.info((CharSequence)("Starting AppSpace with name -> " + appSpaceName + " in Domain -> " + domainName));
        try {
            Response response = this.r.path("/domains").path(domainName).path("appspaces").path(appSpaceName).path("start").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(null);
            this.processErrorResponse(response);
        }
        catch (ProcessingException pe) {
            throw RemoteDeployer.getConnectionException(pe);
        }
        catch (Exception ex) {
            throw new ClientException(500, ex.getMessage(), ex);
        }
    }

    private AppNode createAppNode(String domainName, String appSpaceName, String appNodeName, String agentName, int httpPort, int osgiPort, String description) throws ClientException {
        this.init();
        try {
            this.addQueryParam("agent", String.valueOf(agentName));
            this.addQueryParam("httpport", String.valueOf(httpPort));
            if (osgiPort > 0) {
                this.r = this.r.queryParam("osgiport", new Object[]{String.valueOf(osgiPort)});
            }
            this.addQueryParam("description", description);
            Response response = this.r.path("/domains").path(domainName).path("appspaces").path(appSpaceName).path("appnodes").path(appNodeName).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(null);
            this.processErrorResponse(response);
            AppNode appNode = (AppNode)response.readEntity(AppNode.class);
            return appNode;
        }
        catch (ProcessingException pe) {
            throw RemoteDeployer.getConnectionException(pe);
        }
        catch (Exception ex) {
            throw new ClientException(500, ex.getMessage(), ex);
        }
    }

    private void startAppNode(String domainName, String appSpaceName, String appNodeName) throws ClientException {
        this.init();
        try {
            Response response = this.r.path("/domains").path(domainName).path("appspaces").path(appSpaceName).path("appnodes").path(appNodeName).path("start").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(null);
            this.processErrorResponse(response);
        }
        catch (ProcessingException pe) {
            throw RemoteDeployer.getConnectionException(pe);
        }
        catch (Exception ex) {
            throw new ClientException(500, ex.getMessage(), ex);
        }
    }

    private void uploadArchive(String domainName, String path, String file, boolean replace) throws ClientException {
        this.init();
        try (FormDataMultiPart multipart = new FormDataMultiPart();){
            this.r = this.r.path("/domains").path(domainName).path("archives");
            this.r = this.r.queryParam("replace", new Object[]{replace});
            this.addQueryParam("path", path);
            File fileEntity = new File(file);
            FileDataBodyPart filePart = new FileDataBodyPart("file", fileEntity, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            FormDataContentDisposition.FormDataContentDispositionBuilder builder = FormDataContentDisposition.name((String)"file");
            builder.fileName(URLEncoder.encode(file, "UTF-8"));
            builder.size(fileEntity.length());
            builder.modificationDate(new Date(fileEntity.lastModified()));
            filePart.setFormDataContentDisposition(builder.build());
            multipart.bodyPart((BodyPart)filePart);
            Response response = this.r.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)multipart, (MediaType)multipart.getMediaType()));
            if (!response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                if (response.getMediaType().getType().equals(MediaType.TEXT_HTML_TYPE.getType()) && response.getMediaType().getSubtype().equals(MediaType.TEXT_HTML_TYPE.getSubtype())) {
                    throw new ClientException(response.getStatus(), (String)response.readEntity(String.class), null);
                }
                this.processErrorResponse(response);
            }
        }
        catch (ProcessingException pe) {
            throw RemoteDeployer.getConnectionException(pe);
        }
        catch (Exception ex) {
            throw new ClientException(500, ex.getMessage(), ex);
        }
    }

    private void deployApplication(String domainName, String appSpaceName, String archiveName, String path, boolean startOnDeploy, boolean replace, String profile, boolean externalProfile) throws ClientException {
        this.init();
        try {
            this.r = this.r.queryParam("archivename", new Object[]{archiveName});
            this.addQueryParam("path", path);
            this.r = this.r.queryParam("startondeploy", new Object[]{String.valueOf(startOnDeploy)}).queryParam("replace", new Object[]{String.valueOf(replace)});
            if (externalProfile) {
                this.addQueryParam("profile", "default.substvar");
            } else {
                this.addQueryParam("profile", profile);
            }
            Response response = this.r.path("/domains").path(domainName).path("appspaces").path(appSpaceName).path("applications").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(null);
            this.processErrorResponse(response);
            if (response.getStatus() != 201) {
                throw new ClientException(500, response.getStatus() + ": ", null);
            }
        }
        catch (ProcessingException pe) {
            throw RemoteDeployer.getConnectionException(pe);
        }
        catch (Exception ex) {
            throw new ClientException(500, ex.getMessage(), ex);
        }
    }

    private void undeployApplication(String domainName, String appSpaceName, String appName, String version) throws ClientException {
        this.init();
        try {
            Response response = this.r.path("/domains").path(domainName).path("appspaces").path(appSpaceName).path("applications").path(appName).path(version).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete();
            this.processErrorResponse(response);
        }
        catch (ProcessingException pe) {
            throw RemoteDeployer.getConnectionException(pe);
        }
        catch (Exception ex) {
            throw new ClientException(500, ex.getMessage(), ex);
        }
    }

    private void startApplication(String domainName, String appSpaceName, String appName, String version, String appNodeName) throws ClientException {
        this.init();
        try {
            this.addQueryParam("appnode", appNodeName);
            Response response = this.r.path("/domains").path(domainName).path("appspaces").path(appSpaceName).path("applications").path(appName).path(version).path("start").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(null);
            this.processErrorResponse(response);
        }
        catch (ProcessingException pe) {
            throw RemoteDeployer.getConnectionException(pe);
        }
        catch (Exception ex) {
            throw new ClientException(500, ex.getMessage(), ex);
        }
    }

    private List<AppNode> getAppNodes(String domainName, String appSpaceName, String filter, boolean status) throws ClientException {
        this.init();
        try {
            this.r = this.r.queryParam("domain", new Object[]{domainName}).queryParam("appspace", new Object[]{appSpaceName}).queryParam("status", new Object[]{status});
            this.addQueryParam("filter", filter);
            Response response = this.r.path("/browse").path("appnodes").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
            this.processErrorResponse(response);
            List appSpaces = (List)response.readEntity((GenericType)new GenericType<List<AppNode>>(){});
            return appSpaces;
        }
        catch (ProcessingException pe) {
            throw RemoteDeployer.getConnectionException(pe);
        }
        catch (Exception ex) {
            throw new ClientException(500, ex.getMessage(), ex);
        }
    }

    private List<Archive> getArchives(String domainName, String path, String filter) throws ClientException {
        this.init();
        try {
            this.r = this.r.queryParam("domain", new Object[]{domainName});
            this.addQueryParam("path", path);
            this.addQueryParam("filter", filter);
            Response response = this.r.path("/browse").path("archives").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
            this.processErrorResponse(response);
            List archives = (List)response.readEntity((GenericType)new GenericType<List<Archive>>(){});
            return archives;
        }
        catch (ProcessingException pe) {
            throw RemoteDeployer.getConnectionException(pe);
        }
        catch (Exception ex) {
            throw new ClientException(500, ex.getMessage(), ex);
        }
    }

    private List<Application> getApplications(String domainName, String appSpace, String filter, boolean status) throws ClientException {
        this.init();
        try {
            this.addQueryParam("domain", domainName);
            this.addQueryParam("appspace", appSpace);
            this.addQueryParam("filter", filter);
            this.r = this.r.queryParam("status", new Object[]{status});
            Response response = this.r.path("/browse").path("apps").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
            this.processErrorResponse(response);
            List apps = (List)response.readEntity((GenericType)new GenericType<List<Application>>(){});
            return apps;
        }
        catch (ProcessingException pe) {
            throw RemoteDeployer.getConnectionException(pe);
        }
        catch (Exception ex) {
            throw new ClientException(500, ex.getMessage(), ex);
        }
    }

    private void downloadArchive(String domainName, String path, String name) throws ClientException {
        this.init();
        try {
            Response response = this.r.path("/domains").path(domainName).path("archives").path(name).path("content").request().get();
            this.processErrorResponse(response);
            this.saveArchive(response, path, name);
        }
        catch (ProcessingException pe) {
            throw RemoteDeployer.getConnectionException(pe);
        }
        catch (Exception ex) {
            throw new ClientException(500, ex.getMessage(), ex);
        }
    }

    private void downloadProfileAplication(String domainName, String path, String name, String profileName) throws ClientException {
        this.init();
        try {
            Response response = this.r.path("/domains").path(domainName).path("archives").path(name).path(profileName).request().get();
            this.processErrorResponse(response);
            this.saveArchive(response, path, profileName);
        }
        catch (ProcessingException pe) {
            throw RemoteDeployer.getConnectionException(pe);
        }
        catch (Exception ex) {
            throw new ClientException(500, ex.getMessage(), ex);
        }
    }

    private void saveArchive(Response response, String path, String name) throws IOException {
        FileOutputStream outputStream = null;
        try {
            int bytesRead;
            InputStream inputStream = (InputStream)response.readEntity(InputStream.class);
            String fullPath = path + File.separator + DATE_TIME;
            File file = new File(fullPath);
            FileUtils.forceMkdir((File)file);
            fullPath = fullPath + File.separator + name;
            outputStream = new FileOutputStream(fullPath);
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            this.log.info((CharSequence)("Downloaded successfully at: " + fullPath));
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    this.log.error((Throwable)e);
                }
            }
        }
    }

    private void processErrorResponse(Response response) throws ClientException {
        if (!Response.Status.Family.SUCCESSFUL.equals((Object)response.getStatusInfo().getFamily())) {
            if (response.getStatusInfo().getStatusCode() == 401) {
                throw new ClientException(response.getStatus(), response.getStatusInfo().getStatusCode() + ": " + response.getStatusInfo().getReasonPhrase(), null);
            }
            Error error = (Error)response.readEntity(Error.class);
            if (error != null) {
                throw new ClientException(response.getStatus(), error.getCode() + ": " + error.getMessage(), null);
            }
            throw new ClientException(response.getStatus(), response.getStatusInfo().getReasonPhrase(), null);
        }
    }

    private static ClientException getConnectionException(ProcessingException pe) {
        if (pe.getCause() instanceof ConnectException) {
            return new ClientException(503, pe.getCause().getMessage(), pe.getCause());
        }
        if (pe.getCause() instanceof IllegalStateException) {
            return new ClientException(503, pe.getCause().getMessage(), pe.getCause());
        }
        return new ClientException(500, pe.getMessage(), pe);
    }

    private void addQueryParam(String name, String value) {
        if (value != null) {
            this.r = this.r.queryParam(name, new Object[]{value});
        }
    }
}

