/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.process;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="bwdesignUtility")
public class BWDesignUtilityExecutorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="diagramLoc", defaultValue="")
    private String diagramLoc;
    @Parameter(property="commandName", defaultValue="")
    private String commandName;
    private Log logger = this.getLog();
    String executorHome = null;
    String tibcoHome = null;
    String bwHome = null;
    String binDir = null;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project.getPackaging().equals("bwear")) {
            if (null == this.project.getProperties().getProperty("tibco.Home") || this.project.getProperties().getProperty("tibco.Home").isEmpty()) {
                this.logger.error((CharSequence)"Please provide the Tibco Home in POM ");
                throw new MojoFailureException("Value for Tibco Home is empty");
            }
            this.tibcoHome = this.project.getProperties().getProperty("tibco.Home");
            if (null == this.project.getProperties().getProperty("bw.Home") || this.project.getProperties().getProperty("bw.Home").isEmpty()) {
                this.logger.error((CharSequence)"Please provide the BW Home in POM ");
                throw new MojoFailureException("Value for BW Home is empty");
            }
            this.bwHome = this.project.getProperties().getProperty("bw.Home");
            this.executorHome = this.binDir = this.tibcoHome.concat(this.bwHome).concat("//bin");
            if (null != this.commandName && this.commandName.equals("validate")) {
                this.validateBWProject();
            } else if (null != this.commandName && this.commandName.equals("gen_diagrams")) {
                this.generateProcessDiagram();
            } else {
                this.validateBWProject();
                this.generateProcessDiagram();
            }
        }
    }

    private void generateProcessDiagram() throws MojoExecutionException {
        List<String> params = new ArrayList<String>();
        params = this.createUtilityArgument(params);
        try {
            String line;
            ProcessBuilder builder = new ProcessBuilder(params);
            builder.directory(new File(this.executorHome));
            Process process = builder.start();
            this.logger.info((CharSequence)"---------------------Generating Process diagram-----------------------");
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
            if (null != this.diagramLoc && !this.diagramLoc.isEmpty()) {
                writer.write("diagram:gen_diagrams " + this.project.getName() + " " + this.diagramLoc);
            } else {
                writer.write("diagram:gen_diagrams " + this.project.getName());
            }
            writer.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private List<String> createUtilityArgument(List<String> params) {
        String utilityName = this.executorHome.concat("//bwdesign.exe");
        String workSpaceLocation = this.project.getBasedir().getParent();
        params.add(utilityName);
        params.add("-data");
        params.add(workSpaceLocation);
        return params;
    }

    private void validateBWProject() throws MojoExecutionException {
        Process validateProcess = null;
        List<String> validateParam = new ArrayList<String>();
        validateParam = this.createUtilityArgument(validateParam);
        try {
            String line;
            ProcessBuilder validateBuilder = new ProcessBuilder(validateParam);
            validateBuilder.directory(new File(this.executorHome));
            this.logger.info((CharSequence)"---------------------Validating BW Project-----------------------");
            validateProcess = validateBuilder.start();
            String applicationName = this.project.getName();
            String moduleName = applicationName.replace(".application", "");
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(validateProcess.getOutputStream()));
            writer.write("validate " + moduleName + "," + applicationName);
            writer.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(validateProcess.getInputStream()));
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

