/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.test.setuplocal;

import com.tibco.bw.maven.plugin.test.helpers.BWTestConfig;
import com.tibco.bw.maven.plugin.test.setuplocal.EngineProcessException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

public class EngineRunner {
    CountDownLatch latch = new CountDownLatch(1);
    AtomicBoolean isEngineStarted = new AtomicBoolean(true);

    public void run() throws Exception {
        Process process = null;
        ProcessBuilder builder = new ProcessBuilder(BWTestConfig.INSTANCE.getLaunchConfig());
        process = builder.start();
        BWTestConfig.INSTANCE.getLogger().info((CharSequence)"## Starting BW Engine in Test Mode ##");
        BWTestConfig.INSTANCE.getLogger().info((CharSequence)"----BW Engine Logs Start---------------------------------------------------------------------------------------------------------------------------------------------------");
        BWTestConfig.INSTANCE.getLogger().info((CharSequence)"");
        BWTestConfig.INSTANCE.setEngineProcess(process);
        StringBuilder sb = new StringBuilder();
        Runnable input = this.getInputRunnable(process, sb);
        Runnable error = this.getErrorRunnable(process, sb);
        Thread inputThread = new Thread(input);
        Thread errorThread = new Thread(error);
        inputThread.start();
        errorThread.start();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                System.out.print(".");
            }
        };
        Timer timer = new Timer("Timer");
        timer.schedule(task, 0L, 1500L);
        this.latch.await();
        timer.cancel();
        if (!this.isEngineStarted.get()) {
            throw new EngineProcessException("BW Engine not started successfully.Please see logs for more details");
        }
        BWTestConfig.INSTANCE.getLogger().info((CharSequence)"## BW Engine Successfully Started ##");
    }

    private Runnable getErrorRunnable(final Process process, final StringBuilder sb) {
        Runnable error = new Runnable(){

            @Override
            public void run() {
                try {
                    String line;
                    InputStream is = process.getErrorStream();
                    InputStreamReader isr = new InputStreamReader(is);
                    BufferedReader br = new BufferedReader(isr);
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        return error;
    }

    private Runnable getInputRunnable(final Process process, final StringBuilder sb) {
        Runnable input = new Runnable(){

            @Override
            public void run() {
                try {
                    String line;
                    InputStream is = process.getInputStream();
                    InputStreamReader isr = new InputStreamReader(is);
                    BufferedReader br = new BufferedReader(isr);
                    while ((line = br.readLine()) != null) {
                        System.out.println(line);
                        if (line.contains("Started BW Application")) {
                            EngineRunner.this.latch.countDown();
                        }
                        sb.append(line);
                    }
                    if (EngineRunner.this.latch.getCount() > 0L) {
                        EngineRunner.this.isEngineStarted.set(false);
                        EngineRunner.this.latch.countDown();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        return input;
    }
}

