/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class BWFileUtils {
    public static final char EXTENSION = '.';
    public static final String EXTENSION_STR = Character.toString('.');
    private static final int NOT_PRESENT = -1;
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static String testFolderName = null;

    public static File[] getFilesForType(File target, final String extension) {
        File[] files = target.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().indexOf(extension) != -1;
            }
        });
        return files;
    }

    public static File[] getFilesForTypeRec(File target, String filterDir, String extension) {
        String[] extensions = new String[]{"jar"};
        List files = (List)FileUtils.listFiles((File)target, (String[])extensions, (boolean)true);
        ArrayList<File> filesSel = new ArrayList<File>();
        for (File file : files) {
            if (file.getPath().indexOf(filterDir) != -1) continue;
            filesSel.add(file);
        }
        return filesSel.toArray(new File[0]);
    }

    public static File[] sortFilesByDateDesc(File[] files) {
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                if (o1.lastModified() > o2.lastModified()) {
                    return -1;
                }
                if (o1.lastModified() < o2.lastModified()) {
                    return 1;
                }
                return 0;
            }
        });
        return files;
    }

    public static List<File> getEntitiesfromLocation(String location, final String extension) {
        final ArrayList<File> list = new ArrayList<File>();
        if (location == null || !new File(location).exists()) {
            return list;
        }
        try {
            Files.walkFileTree(Paths.get(location, new String[0]), (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (BWFileUtils.getExtension(file.toString()).equalsIgnoreCase(extension)) {
                        list.add(file.toFile());
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public static String getExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = BWFileUtils.indexOfExtension(filename);
        if (index == -1) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static String replaceLast(String string, String toReplace, String replacement) {
        int pos = string.lastIndexOf(toReplace);
        if (pos > -1) {
            return string.substring(0, pos) + replacement + string.substring(pos + toReplace.length(), string.length());
        }
        return string;
    }

    public static int indexOfExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastSeparator = BWFileUtils.indexOfLastSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    public static String getFileNameWithoutExtn(String fileName) {
        int pos = fileName.lastIndexOf(".");
        String justName = pos > 0 ? fileName.substring(0, pos) : fileName;
        return justName;
    }

    public static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public static String getTestFolderName(String location, final String testSuiteName) {
        try {
            Files.walkFileTree(Paths.get(location, new String[0]), (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (testSuiteName.equalsIgnoreCase(file.toFile().getName())) {
                        testFolderName = file.toFile().getParent();
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return testFolderName;
    }
}

