/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.application;

import com.tibco.bw.maven.plugin.admin.client.RemoteDeployer;
import com.tibco.bw.maven.plugin.admin.dto.Agent;
import com.tibco.bw.maven.plugin.admin.dto.AppSpace;
import com.tibco.bw.maven.plugin.osgi.helpers.ManifestParser;
import com.tibco.bw.maven.plugin.tci.client.TCIDeployer;
import com.tibco.bw.maven.plugin.utils.BWFileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="bwinstall", defaultPhase=LifecyclePhase.INSTALL)
public class BWEARInstallerMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="project.build.directory")
    private File outputDirectory;
    @Parameter(property="project.basedir")
    private File projectBasedir;
    @Parameter(property="project.type")
    private String projectType;
    @Parameter(property="deployToAdmin")
    private boolean deployToAdmin;
    @Parameter(property="agentHost")
    private String agentHost;
    @Parameter(property="agentPort")
    private String agentPort;
    @Parameter(property="agentAuth")
    private String agentAuth;
    @Parameter(property="agentUsername")
    private String agentUsername;
    @Parameter(property="agentPassword")
    private String agentPassword;
    @Parameter(property="agentSSL")
    private boolean agentSSL;
    @Parameter(property="truststorePath")
    private String trustPath;
    @Parameter(property="truststorePassword")
    private String trustPassword;
    @Parameter(property="keystorePath")
    private String keyPath;
    @Parameter(property="keystorePassword")
    private String keyPassword;
    @Parameter(property="domain")
    private String domain;
    @Parameter(property="domainDesc")
    private String domainDesc;
    @Parameter(property="appSpace")
    private String appSpace;
    @Parameter(property="appSpaceDesc")
    private String appSpaceDesc;
    @Parameter(property="appNode")
    private String appNode;
    @Parameter(property="appNodeDesc")
    private String appNodeDesc;
    @Parameter(property="httpPort")
    private String httpPort;
    @Parameter(property="osgiPort")
    private String osgiPort;
    @Parameter(property="profile")
    private String profile;
    @Parameter(property="redeploy")
    private boolean redeploy;
    @Parameter(property="backup")
    private boolean backup;
    @Parameter(property="externalProfile")
    private boolean externalProfile;
    @Parameter(property="externalProfileLoc")
    private String externalProfileLoc;
    @Parameter(property="backupLocation")
    private String backupLocation;
    @Parameter(property="deploymentConfigfile")
    private String deploymentConfigfile;
    @Parameter(property="externalEarLoc")
    private String externalEarLoc;
    @Parameter(property="createAdminCompo", defaultValue="true")
    private boolean createAdminCompo;
    @Parameter(property="appNodeConfig")
    protected Map appNodeConfig;
    @Parameter(property="restartAppNode")
    private boolean restartAppNode;
    @Parameter(property="earUploadPath")
    private String earUploadPath;
    @Parameter(property="retryCount", defaultValue="20")
    private int retryCount;
    @Parameter(property="connectTimeout", defaultValue="120000")
    private int connectTimeout;
    @Parameter(property="readTimeout", defaultValue="120000")
    private int readTimeout;
    @Parameter(property="instanceCount", defaultValue="0")
    private int instanceCount;
    @Parameter(property="appVariablesFile")
    private String appVariablesFile;
    @Parameter(property="engineVariablesFile")
    private String engineVariablesFile;
    @Parameter(property="forceOverwrite", defaultValue="false")
    private boolean forceOverwrite;
    @Parameter(property="retainAppProps", defaultValue="false")
    private boolean retainAppProps;
    @Parameter(property="startOnDeploy", defaultValue="true")
    private boolean startOnDeploy;
    private String earLoc;
    private String earName;
    private String applicationName;

    public void execute() throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)"BWEAR Installer Mojo started ...");
            Manifest manifest = ManifestParser.parseManifest(this.projectBasedir);
            String bwEdition = manifest.getMainAttributes().getValue("TIBCO-BW-Edition");
            if (bwEdition != null && bwEdition.equals("bwcf")) {
                this.getLog().debug((CharSequence)"BWCF edition. Returning..");
                return;
            }
            if (this.projectType != null && this.projectType.equalsIgnoreCase("TCI")) {
                if (!this.deployToAdmin) {
                    this.getLog().info((CharSequence)"Deploy To Admin/TCI is set to False. Skipping EAR Deployment.");
                    return;
                }
                File[] files = BWFileUtils.getFilesForType(this.outputDirectory, ".ear");
                if (files.length == 0) {
                    throw new Exception("EAR file not found for the Application");
                }
                String appName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
                TCIDeployer deployer = new TCIDeployer(this.connectTimeout, this.readTimeout, this.retryCount, this.getLog());
                deployer.deployApp(appName, files[0].getPath(), this.instanceCount, this.appVariablesFile, this.engineVariablesFile, this.forceOverwrite, this.retainAppProps);
                deployer.close();
            } else {
                boolean configFileExists = this.deploymentConfigExists();
                if (configFileExists) {
                    this.loadFromDeploymentProperties();
                }
                if (!this.validateFields()) {
                    this.getLog().error((CharSequence)"Validation failed. Skipping EAR Deployment.");
                    return;
                }
                if (!this.deployToAdmin) {
                    this.getLog().info((CharSequence)"Deploy To Admin/TCI is set to False. Skipping EAR Deployment.");
                    return;
                }
                File[] files = BWFileUtils.getFilesForType(this.outputDirectory, ".ear");
                if (files.length == 0) {
                    throw new Exception("EAR file not found for the Application");
                }
                if (this.externalEarLocExists()) {
                    File f = new File(this.externalEarLoc);
                    Path p = Paths.get(this.externalEarLoc + "/" + files[0].getName(), new String[0]);
                    Files.deleteIfExists(p);
                    FileUtils.copyFileToDirectory((File)files[0], (File)f);
                    this.deriveEARInformation(p.toFile());
                } else {
                    this.deriveEARInformation(files[0]);
                }
                this.applicationName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
                RemoteDeployer deployer = new RemoteDeployer(this.agentHost, Integer.parseInt(this.agentPort), this.agentAuth, this.agentUsername, this.agentPassword, this.agentSSL, this.trustPath, this.trustPassword, this.keyPath, this.keyPassword, this.createAdminCompo, this.connectTimeout, this.readTimeout, this.retryCount, this.startOnDeploy);
                deployer.setLog(this.getLog());
                List<Agent> agents = deployer.getAgentInfo();
                if (agents.size() <= 0) {
                    return;
                }
                this.getLog().info((CharSequence)"Connected to BWAgent. Agents found.");
                String agentName = null;
                for (Agent agent : agents) {
                    agentName = agent.getName();
                    this.getLog().info((CharSequence)("Agent Name -> " + agentName));
                }
                String[] versionNum = manifest.getMainAttributes().getValue("Bundle-Version").split("\\.");
                String version = null;
                if (versionNum.length <= 2) {
                    throw new Exception("Invalid Bundle Version -" + manifest.getMainAttributes().getValue("Bundle-Version"));
                }
                version = versionNum[0] + "." + versionNum[1];
                deployer.getOrCreateDomain(this.domain, this.domainDesc);
                AppSpace appSpaceDto = deployer.getOrCreateAppSpace(this.domain, this.appSpace, this.appSpaceDesc);
                deployer.getOrCreateAppNode(this.domain, this.appSpace, this.appNode, Integer.parseInt(this.httpPort), this.osgiPort == null || this.osgiPort.isEmpty() ? -1 : Integer.parseInt(this.osgiPort), this.appNodeDesc, agentName);
                if (!this.appNodeConfig.isEmpty()) {
                    this.getLog().debug((CharSequence)("Input AppNode Config : " + this.appNodeConfig));
                    deployer.setAppNodeConfig(this.domain, this.appSpace, this.appNode, this.appNodeConfig, this.restartAppNode);
                }
                if (appSpaceDto.getStatus() != AppSpace.AppSpaceRuntimeStatus.Running) {
                    deployer.startAppSpace(this.domain, this.appSpace);
                } else {
                    this.getLog().info((CharSequence)"AppSpace is Running.");
                }
                this.getLog().info((CharSequence)("domain -> " + this.domain + " earName -> " + this.earName + " Ear file to be uploaded -> " + files[0].getAbsolutePath()));
                deployer.addAndDeployApplication(this.domain, this.appSpace, this.applicationName, this.earName, files[0].getAbsolutePath(), this.redeploy, this.profile, this.backup, this.backupLocation, version, this.externalProfile, this.externalProfileLoc, this.appNode, this.earUploadPath);
                deployer.close();
            }
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Failed to deploy BW Application ", e);
        }
    }

    private void deriveEARInformation(File file) {
        this.earLoc = file.getAbsolutePath();
        this.earLoc = this.earLoc.replace("\\", "/");
        this.earName = file.getName();
    }

    private boolean deploymentConfigExists() {
        if (this.deploymentConfigfile == null || this.deploymentConfigfile.isEmpty()) {
            this.getLog().info((CharSequence)"No Deployment Config File set. Reading the deployment Properties from POM File.");
            return false;
        }
        String deploymentFile = this.deploymentConfigfile;
        if (deploymentFile.contains("http") && this.isValidURL(deploymentFile)) {
            this.getLog().info((CharSequence)"External Deployment Config file provided. Loading configuration from the same.");
            return true;
        }
        File file = new File(deploymentFile);
        if (!file.exists()) {
            this.getLog().info((CharSequence)"Deployment Config File not found. Reading the deployment Properties from POM File.");
            return false;
        }
        this.getLog().info((CharSequence)"Deployment Config File found. Loading configuration from the same.");
        return true;
    }

    private boolean isValidURL(String url) {
        try {
            new URL(url).toURI();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean externalEarLocExists() {
        if (this.externalEarLoc == null || this.externalEarLoc.isEmpty()) {
            return false;
        }
        this.getLog().info((CharSequence)("Deploying the Ear from external Ear location: " + this.externalEarLoc));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromDeploymentProperties() throws MalformedURLException, IOException {
        File file = null;
        if (this.deploymentConfigfile.contains("http") && this.isValidURL(this.deploymentConfigfile)) {
            String localFileName = this.deploymentConfigfile.substring(this.deploymentConfigfile.lastIndexOf("/") + 1);
            this.getLog().info((CharSequence)("Deployment config file is from external URL, creating temporary local file - " + localFileName));
            file = new File(localFileName);
            file.delete();
            file.createNewFile();
            FileUtils.copyURLToFile((URL)new URL(this.deploymentConfigfile), (File)file);
        } else {
            file = new File(this.deploymentConfigfile);
        }
        Properties deployment = new Properties();
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            deployment.load(stream);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLog().info((CharSequence)"Failed to load Propeties from Deployment Config File");
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            this.agentHost = deployment.getProperty("agentHost");
            this.agentPort = deployment.getProperty("agentPort");
            this.agentAuth = deployment.getProperty("agentAuth");
            this.agentUsername = deployment.getProperty("agentUsername");
            this.agentPassword = deployment.getProperty("agentPassword");
            this.agentSSL = Boolean.parseBoolean(deployment.getProperty("agentSSL"));
            this.trustPath = deployment.getProperty("truststorePath");
            this.trustPassword = deployment.getProperty("truststorePassword");
            this.keyPath = deployment.getProperty("keystorePath");
            this.keyPassword = deployment.getProperty("keystorePassword");
            this.domain = deployment.getProperty("domain");
            this.domainDesc = deployment.getProperty("domainDesc");
            this.appSpace = deployment.getProperty("appSpace");
            this.appSpaceDesc = deployment.getProperty("appSpaceDesc");
            this.appNode = deployment.getProperty("appNode");
            this.appNodeDesc = deployment.getProperty("appNodeDesc");
            this.httpPort = deployment.getProperty("httpPort");
            this.osgiPort = deployment.getProperty("osgiPort");
            this.profile = deployment.getProperty("profile");
            this.deployToAdmin = Boolean.parseBoolean(deployment.getProperty("deployToAdmin"));
            this.redeploy = Boolean.parseBoolean(deployment.getProperty("redeploy"));
            this.backup = Boolean.parseBoolean(deployment.getProperty("backup"));
            this.backupLocation = deployment.getProperty("backupLocation");
            this.externalProfile = Boolean.parseBoolean(deployment.getProperty("externalProfile"));
            this.externalProfileLoc = deployment.getProperty("externalProfileLoc");
            this.externalEarLoc = deployment.getProperty("externalEarLoc");
            this.earUploadPath = deployment.getProperty("earUploadPath");
            this.getAppNodeConfigProps(deployment);
        }
        catch (Exception e) {
            this.deployToAdmin = false;
            this.getLog().error((Throwable)e);
            this.getLog().info((CharSequence)"Error in Loading Deployment Properties. Skipping EAR Deployment.");
        }
    }

    private void getAppNodeConfigProps(Properties deployment) {
        for (Object propKey : deployment.keySet()) {
            if (!((String)propKey).startsWith("appNodeConfig_")) continue;
            String key = ((String)propKey).split("_")[1];
            if (this.appNodeConfig == null) {
                this.appNodeConfig = new HashMap();
            }
            if (key == null) continue;
            this.appNodeConfig.put(key, deployment.getProperty((String)propKey));
            this.getLog().info((CharSequence)("AppNodeConfig -> " + key + " : " + deployment.getProperty((String)propKey)));
        }
    }

    private boolean validateFields() {
        boolean isValidAppNode;
        boolean isValidAppSpace;
        boolean isValidDomain;
        boolean isValidHost;
        StringBuffer errorMessage = new StringBuffer();
        boolean bl = isValidHost = this.agentHost != null && !this.agentHost.isEmpty();
        if (!isValidHost) {
            errorMessage.append("[Agent Host value is required]");
        }
        boolean isValidPort = false;
        try {
            if (this.agentPort == null || this.agentPort.isEmpty()) {
                errorMessage.append("[Agent Port value is required]");
            } else if (Integer.parseInt(this.agentPort) <= 0) {
                errorMessage.append("[Agent Port value must be an Integer]");
            } else if (Integer.parseInt(this.agentPort) > 65535) {
                errorMessage.append("[Agent Port value is invalid]");
            } else {
                isValidPort = true;
            }
        }
        catch (Exception e) {
            errorMessage.append("[Agent Port value must be an Integer]");
        }
        boolean bl2 = isValidDomain = this.domain != null && !this.domain.isEmpty();
        if (!isValidDomain) {
            errorMessage.append("[Domain Value is required]");
        }
        boolean bl3 = isValidAppSpace = this.appSpace != null && !this.appSpace.isEmpty();
        if (!isValidAppSpace) {
            errorMessage.append("[AppSpace Value is required]");
        }
        boolean bl4 = isValidAppNode = this.appNode != null && !this.appNode.isEmpty();
        if (!isValidAppNode) {
            errorMessage.append("[AppNode Value is required]");
        }
        boolean isValidHTTPPort = false;
        try {
            if (this.httpPort == null || this.httpPort.isEmpty()) {
                errorMessage.append("[HTTP Port value is required]");
            } else if (Integer.parseInt(this.httpPort) < 0) {
                errorMessage.append("[HTTP Port value must be an Integer]");
            } else {
                isValidHTTPPort = true;
            }
        }
        catch (Exception e) {
            errorMessage.append("[HTTP Port value must be an Integer]");
        }
        boolean isValidOSGi = false;
        try {
            if (this.osgiPort == null || this.osgiPort.isEmpty()) {
                isValidOSGi = true;
            } else if (Integer.parseInt(this.osgiPort) < 0) {
                isValidOSGi = false;
                errorMessage.append("[OSGi Port value must be an Integer]");
            } else {
                isValidOSGi = true;
            }
        }
        catch (Exception e) {
            errorMessage.append("[OSGi Port value must be an Integer]");
        }
        boolean isValidBackupLoc = true;
        if (this.backup && (this.backupLocation == null || this.backupLocation.isEmpty())) {
            isValidBackupLoc = false;
            errorMessage.append("[Backup Location value is required]");
        }
        boolean isValidexternalProfileLoc = true;
        if (this.externalProfile && this.externalProfileLoc.isEmpty()) {
            isValidexternalProfileLoc = false;
            errorMessage.append("[external Profile Location value is required]");
        }
        boolean isValidCredential = true;
        if (this.agentAuth != null && ("BASIC".equalsIgnoreCase(this.agentAuth) || "DIGEST".equalsIgnoreCase(this.agentAuth))) {
            if (this.agentUsername == null || this.agentUsername.isEmpty()) {
                isValidCredential = false;
                errorMessage.append("[Agent Username value is required]");
            }
            if (this.agentPassword == null || this.agentPassword.isEmpty()) {
                isValidCredential = false;
                errorMessage.append("[Agent Password value is required]");
            }
        }
        boolean isValidSSL = true;
        if (this.agentSSL) {
            if (this.trustPath == null || this.trustPath.isEmpty()) {
                isValidSSL = false;
                errorMessage.append("[Truststore File Path value is required]");
            }
            if (this.trustPassword == null || this.trustPassword.isEmpty()) {
                isValidSSL = false;
                errorMessage.append("[Truststore Password value is required]");
            }
        }
        if (!errorMessage.toString().isEmpty()) {
            this.getLog().error((CharSequence)errorMessage.toString());
            return false;
        }
        return isValidHost && isValidPort && isValidDomain && isValidAppSpace && isValidAppNode && isValidHTTPPort && isValidOSGi && isValidBackupLoc && isValidCredential && isValidSSL && isValidexternalProfileLoc;
    }
}

