/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.module;

import com.tibco.bw.maven.plugin.build.BuildProperties;
import com.tibco.bw.maven.plugin.build.BuildPropertiesParser;
import com.tibco.bw.maven.plugin.osgi.helpers.ManifestParser;
import com.tibco.bw.maven.plugin.osgi.helpers.ManifestWriter;
import com.tibco.bw.maven.plugin.osgi.helpers.VersionParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.TypeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.eclipse.aether.graph.Dependency;

@Mojo(name="bwmodule", defaultPhase=LifecyclePhase.PACKAGE)
public class BWModulePackageMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(property="project.basedir")
    private File projectBasedir;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File classesDirectory;
    @Parameter(defaultValue="timestamp")
    private String qualifierReplacement;
    private Manifest manifest;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Component
    DependencyGraphBuilder builder;
    @Component
    ProjectDependenciesResolver resolver;
    MavenArchiver archiver;
    @Parameter
    protected MavenArchiveConfiguration archiveConfiguration;

    public void execute() throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)("Module Packager Mojo started for Module " + this.project.getName() + " ..."));
            MavenArchiver archiver = new MavenArchiver();
            this.archiveConfiguration = new MavenArchiveConfiguration();
            archiver.setArchiver(this.jarArchiver);
            this.manifest = ManifestParser.parseManifest(this.projectBasedir);
            if (this.manifest == null) {
                throw new Exception("Failed to parse MANIFEST.MF for project -> " + this.projectBasedir);
            }
            this.getLog().info((CharSequence)"Updated the Manifest version ");
            ManifestWriter.updateManifestVersion(this.project, this.manifest, this.qualifierReplacement);
            this.updateManifestVersion();
            this.getLog().info((CharSequence)"Removing the externals entries if any. ");
            this.removeExternals();
            File pluginFile = this.getPluginJAR();
            this.getLog().info((CharSequence)("Created Plugin JAR with name " + pluginFile.toString()));
            FileSet set = this.getFileSet();
            this.getLog().info((CharSequence)"Adding Maven Dependencies to the Plugin JAR file");
            this.addDependencies();
            if (this.classesDirectory != null && this.classesDirectory.exists()) {
                archiver.getArchiver().addDirectory(this.classesDirectory);
            }
            archiver.getArchiver().addFileSet(set);
            archiver.setOutputFile(pluginFile);
            File manifestFile = ManifestWriter.updateManifest(this.project, this.manifest);
            this.jarArchiver.setManifest(manifestFile);
            this.getLog().info((CharSequence)"Creating the Plugin JAR file");
            archiver.createArchive(this.session, this.project, this.archiveConfiguration);
            this.project.getArtifact().setFile(pluginFile);
            String bwEdition = this.manifest.getMainAttributes().getValue("TIBCO-BW-Edition");
            if (bwEdition != null && bwEdition.equals("bwcf")) {
                ArrayList<MavenProject> amendedProjects = new ArrayList<MavenProject>();
                for (MavenProject proj : this.session.getAllProjects()) {
                    if (proj.getArtifactId().equals(this.project.getArtifactId())) {
                        amendedProjects.add(this.project);
                        continue;
                    }
                    amendedProjects.add(proj);
                }
                this.session.setAllProjects(amendedProjects);
            }
            this.getLog().info((CharSequence)"BW Module Packager Mojo finished execution.");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error assembling JAR", (Exception)e);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error assembling JAR", (Exception)((Object)e));
        }
        catch (ManifestException e) {
            throw new MojoExecutionException("Error assembling JAR", (Exception)((Object)e));
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Error assembling JAR", (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling JAR", e);
        }
    }

    private void addDependencies() throws Exception {
        this.getLog().debug((CharSequence)"Adding Maven dependencies to the JAR file");
        Set artifacts = this.project.getDependencyArtifacts();
        HashMap<File, String> artifactFiles = new HashMap<File, String>();
        for (Object artifact : artifacts) {
            if (artifact.getVersion().equals("0.0.0")) continue;
            artifactFiles.put(artifact.getFile(), artifact.getScope());
        }
        DependencyResolutionResult resolutionResult = this.getDependencies();
        this.getLog().debug((CharSequence)resolutionResult.toString());
        this.getLog().debug((CharSequence)resolutionResult.getDependencies().toString());
        if (resolutionResult != null) {
            for (Dependency dependency : resolutionResult.getDependencies()) {
                this.getLog().debug((CharSequence)("Adding artifact for dependency => " + dependency + ". The file for Dependency is => " + dependency.getArtifact().getFile()));
                if (dependency.getArtifact().getVersion().equals("0.0.0")) continue;
                artifactFiles.put(dependency.getArtifact().getFile(), dependency.getScope());
            }
        }
        StringBuffer buffer = new StringBuffer();
        for (File file : artifactFiles.keySet()) {
            if (((String)artifactFiles.get(file)).equalsIgnoreCase("provided") || ((String)artifactFiles.get(file)).equalsIgnoreCase("test") || ((String)artifactFiles.get(file)).equalsIgnoreCase("system") || file.getName().indexOf("com.tibco.bw.palette.shared") != -1 || file.getName().indexOf("com.tibco.xml.cxf.common") != -1 || file.getName().indexOf("tempbw") != -1) continue;
            boolean isSharedModule = false;
            Manifest mf = ManifestParser.parseManifestFromJAR(file);
            if (mf == null) {
                throw new Exception("Failed to get Manifest for - " + file.getName() + ". Please verify if jar file is valid, the MANIFEST.MF should be first or second entry in the jar file. Use Command - jar tf <Jar_File_Path> to verify.");
            }
            for (Object str : mf.getMainAttributes().keySet()) {
                this.getLog().debug((CharSequence)str.toString());
                if (!"TIBCO-BW-SharedModule".equals(str.toString())) continue;
                isSharedModule = true;
                break;
            }
            if (isSharedModule) continue;
            this.getLog().debug((CharSequence)("Dependency added with name " + file.toString()));
            this.jarArchiver.addFile(file, "lib/" + file.getName());
            buffer.append(",lib/" + file.getName());
        }
        String bundleClasspath = this.manifest.getMainAttributes().getValue("Bundle-ClassPath");
        if (bundleClasspath == null || bundleClasspath.isEmpty()) {
            bundleClasspath = ".";
        }
        bundleClasspath = bundleClasspath + buffer.toString();
        this.getLog().debug((CharSequence)("Final Bundle-Classpath is " + bundleClasspath));
        this.manifest.getMainAttributes().putValue("Bundle-ClassPath", bundleClasspath);
    }

    private DependencyResolutionResult getDependencies() {
        DependencyResolutionResult resolutionResult = null;
        try {
            this.getLog().debug((CharSequence)("Looking up dependency tree for the current project => " + this.project + " and the current session => " + this.session));
            DefaultDependencyResolutionRequest resolution = new DefaultDependencyResolutionRequest(this.project, this.session.getRepositorySession());
            resolutionResult = this.resolver.resolve((DependencyResolutionRequest)resolution);
        }
        catch (DependencyResolutionException e) {
            this.getLog().debug((CharSequence)("Caught DependencyResolutionException for the project => " + e.getMessage() + " with cause => " + e.getCause()));
            e.printStackTrace();
            resolutionResult = e.getResult();
        }
        return resolutionResult;
    }

    private FileSet getFileSet() {
        BuildProperties buildProperties = BuildPropertiesParser.parse(this.projectBasedir);
        List<String> binIncludesList = buildProperties.getBinIncludes();
        List<String> binExcludeList = buildProperties.getBinExcludes();
        this.getLog().debug((CharSequence)("BinInclude list is " + binIncludesList.toString()));
        this.getLog().debug((CharSequence)("BinExclude list is " + binExcludeList.toString()));
        FileSet set = this.getFileSet(this.projectBasedir, binIncludesList, binExcludeList);
        return set;
    }

    private void calculateDependencies(Artifact artifact) {
        TypeArtifactFilter filter = new TypeArtifactFilter("jar");
        filter.include(artifact);
        try {
            DependencyNode node = this.builder.buildDependencyGraph(this.project, (ArtifactFilter)filter);
            node.getArtifact();
            node.accept(new DependencyNodeVisitor(){

                public boolean visit(DependencyNode node) {
                    node.getArtifact();
                    return true;
                }

                public boolean endVisit(DependencyNode node) {
                    return true;
                }
            });
        }
        catch (DependencyGraphBuilderException e) {
            e.printStackTrace();
        }
    }

    private File getPluginJAR() {
        String name;
        String qualifierVersion = this.manifest.getMainAttributes().getValue("Bundle-Version");
        if (qualifierVersion != null && qualifierVersion.endsWith(".")) {
            qualifierVersion = qualifierVersion.substring(0, qualifierVersion.lastIndexOf("."));
        }
        if ((name = this.manifest.getMainAttributes().getValue("Bundle-SymbolicName")).indexOf(";") != -1) {
            name = name.substring(0, name.indexOf(";") - 1);
        }
        this.getLog().debug((CharSequence)("Creating Plugin JAR from name  " + name));
        File pluginFile = new File(this.outputDirectory, name + "_" + qualifierVersion + ".jar");
        if (pluginFile.exists()) {
            pluginFile.delete();
        }
        return pluginFile;
    }

    protected FileSet getFileSet(File basedir, List<String> includes, List<String> excludes) {
        DefaultFileSet fileSet = new DefaultFileSet();
        fileSet.setDirectory(basedir);
        if (includes.contains("target/")) {
            includes.remove("target/");
        }
        if (this.isSharedModule()) {
            if (!includes.contains(".config")) {
                includes.add(".config");
            }
            if (!includes.contains(".project")) {
                includes.add(".project");
            }
        }
        if (includes.isEmpty()) {
            fileSet.setIncludes(new String[]{""});
        } else {
            fileSet.setIncludes(includes.toArray(new String[includes.size()]));
        }
        LinkedHashSet<String> allExcludes = new LinkedHashSet<String>();
        if (excludes != null) {
            allExcludes.addAll(excludes);
        }
        fileSet.setExcludes(allExcludes.toArray(new String[allExcludes.size()]));
        return fileSet;
    }

    protected boolean isSharedModule() {
        return this.manifest.getMainAttributes().getValue("TIBCO-BW-SharedModule") != null;
    }

    private void updateManifestVersion() {
        String version = this.manifest.getMainAttributes().getValue("Bundle-Version");
        String qualifierVersion = VersionParser.getcalculatedOSGiVersion(version, this.qualifierReplacement);
        this.getLog().info((CharSequence)("The OSGi verion is " + qualifierVersion + " for Maven version of " + version));
        this.manifest.getMainAttributes().putValue("Bundle-Version", qualifierVersion);
    }

    private void removeExternals() {
        String bundlePath = this.manifest.getMainAttributes().getValue("Bundle-ClassPath");
        this.getLog().debug((CharSequence)("Bundle Classpath before removing externals is " + bundlePath));
        if (bundlePath != null) {
            String[] entries = bundlePath.split(",");
            StringBuffer buffer = new StringBuffer();
            for (String entry : entries) {
                if (entry.indexOf("external") != -1) continue;
                if (buffer.length() != 0) {
                    buffer.append(",");
                }
                buffer.append(entry);
            }
            this.getLog().debug((CharSequence)("Bundle Classpath after removing externals is " + buffer.toString()));
            this.manifest.getMainAttributes().putValue("Bundle-ClassPath", buffer.toString());
        }
    }
}

