/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.test;

import com.tibco.bw.maven.plugin.test.helpers.BWTestConfig;
import com.tibco.bw.maven.plugin.test.helpers.TestFileParser;
import com.tibco.bw.maven.plugin.test.setuplocal.BWTestExecutor;
import com.tibco.bw.maven.plugin.utils.BWFileUtils;
import java.io.File;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="bwtest", defaultPhase=LifecyclePhase.TEST)
public class BWTestMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="testFailureIgnore", defaultValue="false")
    private boolean testFailureIgnore;
    @Parameter(property="skipTests", defaultValue="false")
    protected boolean skipTests;
    @Parameter(property="failIfNoTests", defaultValue="true")
    private boolean failIfNoTests;
    @Parameter(property="disableMocking", defaultValue="false")
    private boolean disableMocking;
    @Parameter(property="disableAssertions", defaultValue="false")
    private boolean disableAssertions;
    @Parameter(property="engineDebugPort", defaultValue="8090")
    private int engineDebugPort;
    @Parameter(property="showFailureDetails", defaultValue="true")
    private boolean showFailureDetails;
    @Parameter(property="testSuiteName", defaultValue="")
    private String testSuiteName;
    @Parameter(property="engineStartupWaitTime", defaultValue="2")
    private int engineStartupWaitTime;
    @Parameter(property="osgiCommands")
    private List<String> osgiCommands;
    @Parameter(property="skipInitMainProcessActivities", defaultValue="false")
    private boolean skipInitMainProcessActivities;
    @Parameter(property="skipInitAllNonTestProcessActivities", defaultValue="false")
    private boolean skipInitAllNonTestProcessActivities;
    @Parameter(property="customArgEngine")
    private String customArgEngine;

    public void execute() throws MojoExecutionException, MojoFailureException {
        BWTestExecutor executor = new BWTestExecutor();
        try {
            this.session.getProjects();
            if (!this.verifyParameters()) {
                return;
            }
            this.initialize();
            executor.execute();
        }
        catch (Exception e) {
            if (e instanceof MojoFailureException) {
                if (!this.testFailureIgnore) {
                    throw (MojoFailureException)e;
                }
                System.out.println("Ignoring the exception for generating the report");
            }
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private boolean verifyParameters() throws Exception {
        if (this.isSkipTests()) {
            this.getLog().info((CharSequence)"-------------------------------------------------------");
            this.getLog().info((CharSequence)"Skipping Test phase.");
            this.getLog().info((CharSequence)"-------------------------------------------------------");
            return false;
        }
        String tibcoHome = this.project.getProperties().getProperty("tibco.Home");
        String bwHome = this.project.getProperties().getProperty("bw.Home");
        if (tibcoHome == null || tibcoHome.isEmpty() || bwHome == null || bwHome.isEmpty()) {
            this.getLog().info((CharSequence)"-------------------------------------------------------");
            this.getLog().info((CharSequence)"TIBCO Home or BW Home is not provided. Skipping Test Phase.");
            this.getLog().info((CharSequence)"-------------------------------------------------------");
            return false;
        }
        File file = new File(tibcoHome + bwHome);
        if (!file.exists() || !file.isDirectory()) {
            this.getLog().info((CharSequence)"-------------------------------------------------------");
            this.getLog().info((CharSequence)("Provided TibcoHome directory - " + tibcoHome + bwHome + " is invalid. Skipping Test Phase."));
            this.getLog().info((CharSequence)"-------------------------------------------------------");
            return false;
        }
        boolean exists = this.checkForTest();
        if (this.getFailIfNoTests()) {
            if (!exists) {
                throw new MojoFailureException("No Test files existing in any of the Module.");
            }
        } else if (!exists) {
            this.getLog().info((CharSequence)"-------------------------------------------------------");
            this.getLog().info((CharSequence)"No Tests found in any Module. Skipping Test Phase.");
            this.getLog().info((CharSequence)"-------------------------------------------------------");
            return false;
        }
        return true;
    }

    private boolean checkForTest() {
        List projects = this.session.getProjects();
        for (MavenProject project : projects) {
            List<File> files;
            if (!project.getPackaging().equals("bwmodule") || (files = BWFileUtils.getEntitiesfromLocation(project.getBasedir().toString(), "bwt")).size() <= 0) continue;
            return true;
        }
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.getLog().info((CharSequence)"No BWT Test files exist. ");
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        return false;
    }

    private void initialize() throws Exception {
        String tibcoHome = this.project.getProperties().getProperty("tibco.Home");
        String bwHome = this.project.getProperties().getProperty("bw.Home");
        TestFileParser.INSTANCE.setdisbleMocking(this.disableMocking);
        TestFileParser.INSTANCE.setdisbleAssertions(this.disableAssertions);
        TestFileParser.INSTANCE.setshowFailureDetails(this.showFailureDetails);
        BWTestExecutor.INSTANCE.setEngineDebugPort(this.engineDebugPort);
        BWTestExecutor.INSTANCE.setEngineStartupWaitTime(this.engineStartupWaitTime);
        BWTestExecutor.INSTANCE.setOsgiCommands(this.osgiCommands);
        BWTestExecutor.INSTANCE.setSkipInitMainProcessActivities(this.skipInitMainProcessActivities);
        BWTestExecutor.INSTANCE.setSkipInitAllNonTestProcessActivities(this.skipInitAllNonTestProcessActivities);
        BWTestExecutor.INSTANCE.setCustomArgEngine(this.customArgEngine);
        BWTestConfig.INSTANCE.reset();
        BWTestConfig.INSTANCE.setTestSuiteName(this.testSuiteName);
        BWTestConfig.INSTANCE.init(tibcoHome, bwHome, this.session, this.project, this.getLog());
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.getLog().info((CharSequence)" Running BW Tests ");
        this.getLog().info((CharSequence)"-------------------------------------------------------");
    }

    public boolean isSkipTests() {
        if (!this.skipTests && "true".equals(this.project.getProperties().get("skipTests"))) {
            return true;
        }
        return this.skipTests;
    }

    public void setSkipTests(boolean skipTests) {
        this.skipTests = skipTests;
    }

    public boolean isTestFailureIgnore() {
        return this.testFailureIgnore;
    }

    public void setTestFailureIgnore(boolean testFailureIgnore) {
        this.testFailureIgnore = testFailureIgnore;
    }

    public boolean getFailIfNoTests() {
        return this.failIfNoTests;
    }

    public void setFailIfNoTests(boolean failIfNoTests) {
        this.failIfNoTests = failIfNoTests;
    }
}

