/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

@Mojo(name="bwfabric8json", defaultPhase=LifecyclePhase.INSTALL)
public class BWJsonMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.projectBuildingRequest.activeProfileIds}", property="profile", required=false)
    private List<String> profileIds;

    private String getWorkspacepath() {
        String workspacePath = System.getProperty("user.dir");
        String wsPath = workspacePath;
        if (wsPath.indexOf(".parent") != -1) {
            wsPath = workspacePath.substring(0, workspacePath.lastIndexOf(".parent"));
        }
        return wsPath;
    }

    public static void mkDirs(File root, List<String> dirs, int pos) {
        if (dirs != null) {
            if (pos == dirs.size()) {
                return;
            }
            String s = dirs.get(pos);
            File subdir = new File(root, s);
            if (!subdir.exists()) {
                subdir.mkdir();
            }
            BWJsonMojo.mkDirs(subdir, dirs, pos + 1);
        }
    }

    private void copyFile(File source, File destin) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(source);
        FileOutputStream out = new FileOutputStream(destin);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    private Properties getK8sPropertiesFromFile() throws MojoExecutionException {
        String file = this.getWorkspacepath() + File.separator + "k8s-dev.properties";
        String profile = null;
        if (this.profileIds != null && !this.profileIds.isEmpty()) {
            profile = this.profileIds.get(0);
        }
        if (profile != null) {
            file = this.getWorkspacepath() + File.separator + "k8s-" + profile + ".properties";
        }
        Properties prop = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            prop.load(input);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not load input from " + file + " due to exception: " + e);
        }
        return prop;
    }

    private Properties getDockerPropertiesFromFile() throws MojoExecutionException {
        String fileDocker = this.getWorkspacepath() + File.separator + "docker-dev.properties";
        String profile = null;
        if (this.profileIds != null && !this.profileIds.isEmpty()) {
            profile = this.profileIds.get(0);
        }
        if (profile != null) {
            fileDocker = this.getWorkspacepath() + File.separator + "docker-" + profile + ".properties";
        }
        Properties propsDocker = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream(fileDocker);
            propsDocker.load(input);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not load input from " + fileDocker + " due to exception: " + e);
        }
        return propsDocker;
    }

    private void writeToYamlFile(String location, Map<String, Object> data) throws MojoExecutionException {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yml = new Yaml(options);
        FileWriter writer = null;
        try {
            writer = new FileWriter(location);
        }
        catch (IOException e1) {
            throw new MojoExecutionException("Could not write to service.yml due to exception: " + e1);
        }
        if (writer != null) {
            yml.dump(data, (Writer)writer);
        }
    }

    private String getAppVersion() throws MojoExecutionException {
        MavenXpp3Reader reader = new MavenXpp3Reader();
        Model model = null;
        String version = null;
        try {
            model = reader.read((Reader)new FileReader(this.getWorkspacepath() + ".parent" + File.separator + "pom.xml"));
        }
        catch (FileNotFoundException e1) {
            throw new MojoExecutionException("File pom.xml not found for reading application version");
        }
        catch (IOException e1) {
            throw new MojoExecutionException("Exception while reading pom.xml : " + e1);
        }
        catch (XmlPullParserException e1) {
            throw new MojoExecutionException("Error while parsing POM file: " + e1);
        }
        if (model != null) {
            version = model.getVersion();
        }
        return version;
    }

    private void createServiceYmlFile(Properties k8sprop) throws MojoExecutionException {
        String locationService = this.getWorkspacepath() + File.separator + "src/main/fabric8/service.yml";
        File serviceFile = new File(Paths.get(locationService, new String[0]).toString());
        try {
            serviceFile.createNewFile();
        }
        catch (IOException e1) {
            throw new MojoExecutionException("Could not create file service.yml due to exception: " + e1);
        }
        HashMap<String, Object> dataService = new HashMap<String, Object>();
        dataService.put("kind", "Service");
        HashMap<String, Object> metadataService = new HashMap<String, Object>();
        metadataService.put("name", k8sprop.getProperty("fabric8.service.name"));
        HashMap<String, String> serviceLabels = new HashMap<String, String>();
        serviceLabels.put("container", k8sprop.getProperty("fabric8.container.name"));
        serviceLabels.put("project", k8sprop.getProperty("fabric8.label.project"));
        serviceLabels.put("provider", "fabric8");
        serviceLabels.put("group", "com.tibco.bw");
        metadataService.put("labels", serviceLabels);
        metadataService.put("namespace", k8sprop.getProperty("fabric8.namespace"));
        dataService.put("metadata", metadataService);
        HashMap<String, Object> specdataService = new HashMap<String, Object>();
        specdataService.put("type", k8sprop.getProperty("fabric8.service.type"));
        ArrayList portsList = new ArrayList();
        HashMap<String, Object> portInfo = new HashMap<String, Object>();
        portInfo.put("port", Integer.parseInt(k8sprop.getProperty("fabric8.service.port")));
        portInfo.put("targetPort", Integer.parseInt(k8sprop.getProperty("fabric8.service.containerPort")));
        portInfo.put("protocol", "TCP");
        portsList.add(portInfo);
        specdataService.put("ports", portsList);
        HashMap<String, String> appInfo = new HashMap<String, String>();
        appInfo.put("container", k8sprop.getProperty("fabric8.container.name"));
        appInfo.put("project", k8sprop.getProperty("fabric8.label.project"));
        appInfo.put("provider", "fabric8");
        appInfo.put("group", "com.tibco.bw");
        specdataService.put("selector", appInfo);
        dataService.put("spec", specdataService);
        this.writeToYamlFile(locationService, dataService);
    }

    private void createDeploymentYmlFile(Properties k8sprops, Properties dockerProps) throws MojoExecutionException {
        String locationDeployment = this.getWorkspacepath() + File.separator + "src/main/fabric8/deployment.yml";
        File deploymentFile = new File(Paths.get(locationDeployment, new String[0]).toString());
        try {
            deploymentFile.createNewFile();
        }
        catch (IOException e1) {
            throw new MojoExecutionException("Could not create file deployment.yml due to exception: " + e1);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("kind", "Deployment");
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("name", k8sprops.getProperty("fabric8.replicationController.name"));
        data.put("metadata", metadata);
        HashMap<String, Serializable> specdata = new HashMap<String, Serializable>();
        specdata.put("replicas", Integer.valueOf(Integer.parseInt(k8sprops.getProperty("fabric8.replicas"))));
        HashMap<String, String> appInfoDeployment = new HashMap<String, String>();
        appInfoDeployment.put("container", k8sprops.getProperty("fabric8.container.name"));
        appInfoDeployment.put("project", k8sprops.getProperty("fabric8.label.project"));
        appInfoDeployment.put("provider", "fabric8");
        appInfoDeployment.put("group", "com.tibco.bw");
        specdata.put("selector", appInfoDeployment);
        HashMap template = new HashMap();
        metadata = new HashMap();
        metadata.put("name", k8sprops.getProperty("fabric8.replicationController.name"));
        HashMap<String, String> appInfoLabel = new HashMap<String, String>();
        appInfoLabel.put("container", k8sprops.getProperty("fabric8.container.name"));
        appInfoLabel.put("project", k8sprops.getProperty("fabric8.label.project"));
        metadata.put("labels", appInfoLabel);
        metadata.put("namespace", k8sprops.getProperty("fabric8.namespace"));
        template.put("metadata", metadata);
        ArrayList containerData = new ArrayList();
        HashMap<String, Object> containerInfo = new HashMap<String, Object>();
        containerInfo.put("name", k8sprops.getProperty("fabric8.container.name"));
        containerInfo.put("image", dockerProps.getProperty("docker.image"));
        String version = this.getAppVersion();
        if (version != null && version.endsWith("SNAPSHOT")) {
            containerInfo.put("imagePullPolicy", "Always");
        }
        ArrayList envList = new ArrayList();
        Set<Object> envKeys = k8sprops.keySet();
        ArrayList<String> envVars = new ArrayList<String>();
        if (envKeys != null) {
            for (Object key : envKeys) {
                String keyVal = key.toString();
                if (keyVal == null || !keyVal.startsWith("fabric8.env")) continue;
                envVars.add(keyVal);
            }
        }
        if (envVars != null) {
            for (int e = 0; e < envVars.size(); ++e) {
                String varName;
                HashMap<String, String> env = new HashMap<String, String>();
                String envName = varName = (String)envVars.get(e);
                if (varName != null && varName.startsWith("fabric8.env")) {
                    envName = varName.replace("fabric8.env.", "");
                }
                env.put("name", envName);
                env.put("value", k8sprops.getProperty(varName));
                envList.add(env);
            }
        }
        containerInfo.put("env", envList);
        ArrayList portsList = new ArrayList();
        HashMap<String, Integer> portInfo = new HashMap<String, Integer>();
        portInfo.put("containerPort", Integer.parseInt(k8sprops.getProperty("fabric8.service.containerPort")));
        portsList.add(portInfo);
        containerInfo.put("ports", portsList);
        containerData.add(containerInfo);
        HashMap specdata1 = new HashMap();
        specdata1.put("containers", containerData);
        template.put("spec", specdata1);
        specdata.put("template", template);
        data.put("spec", specdata);
        this.writeToYamlFile(locationDeployment, data);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File root = new File(String.valueOf(this.getWorkspacepath()));
        ArrayList<String> dirs = new ArrayList<String>();
        dirs.add("src");
        dirs.add("main");
        dirs.add("fabric8");
        BWJsonMojo.mkDirs(root, dirs, 0);
        File dstdir = new File(String.valueOf(this.getWorkspacepath()) + File.separator + "src/main/fabric8");
        for (File fileDst : dstdir.listFiles()) {
            if (fileDst.isDirectory()) continue;
            fileDst.delete();
        }
        Properties prop = this.getK8sPropertiesFromFile();
        if (prop.getProperty("fabric8.resources.location") != null && !prop.getProperty("fabric8.resources.location").isEmpty()) {
            File srcdir = new File(prop.getProperty("fabric8.resources.location"));
            if (!srcdir.exists() || !dstdir.exists()) {
                throw new MojoExecutionException("Required directories do not exist for loading the resources");
            }
            String[] children = srcdir.list();
            for (int i = 0; i < children.length; ++i) {
                try {
                    String filename = children[i];
                    if (filename == null || !filename.endsWith(".yml") && !filename.endsWith(".yaml")) continue;
                    this.copyFile(new File(srcdir, filename), new File(dstdir, filename));
                    continue;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Could not copy YML files from " + srcdir + " to " + dstdir + " due to exception: " + e);
                }
            }
        } else {
            Properties propsDocker = this.getDockerPropertiesFromFile();
            this.createServiceYmlFile(prop);
            this.createDeploymentYmlFile(prop, propsDocker);
        }
    }
}

