/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.osgi.helpers;

import com.tibco.bw.maven.plugin.osgi.helpers.Version;
import com.tibco.bw.maven.plugin.osgi.helpers.VersionParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class ManifestParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest parseManifest(File baseDir) {
        Manifest mf = null;
        File mfile = new File(baseDir, "META-INF/MANIFEST.MF");
        if (mfile.exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(mfile);
                mf = new Manifest(is);
            }
            catch (FileNotFoundException f) {
                f.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return mf;
    }

    public static Manifest parseManifestFromJAR(File jarFile) {
        Manifest moduleManifest = null;
        try {
            JarInputStream jarStream = new JarInputStream(new FileInputStream(jarFile));
            moduleManifest = jarStream.getManifest();
            jarStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return moduleManifest;
    }

    public static String getUpdatedProvideCapabilities(Manifest manifest, String oldVersion) {
        String capabilities;
        Object updatedProvidesCapabilities = "";
        Version versionObject = VersionParser.parseVersion(oldVersion);
        String newVersion = versionObject.getMajor() + "." + versionObject.getMinor() + "." + versionObject.getMicro();
        if (manifest != null && (capabilities = manifest.getMainAttributes().getValue("Provide-Capability")) != null && !capabilities.isEmpty()) {
            String entry;
            int i;
            String[] entries = capabilities.split(",");
            boolean updated = false;
            for (i = 0; i < entries.length; ++i) {
                entry = entries[i];
                String[] filters = entry.split(";");
                if (filters[0].trim().equals("com.tibco.bw.module")) {
                    filters[2] = "version:Version=\"" + newVersion + "\"";
                    updated = true;
                }
                if (!updated) continue;
                String newEntry = filters[0].trim() + "; " + filters[1].trim() + "; " + filters[2].trim();
                entries[i] = newEntry;
                break;
            }
            if (updated) {
                for (i = 0; i < entries.length; ++i) {
                    entry = entries[i];
                    updatedProvidesCapabilities = (String)updatedProvidesCapabilities + entry;
                    if (i >= entries.length - 1) continue;
                    updatedProvidesCapabilities = (String)updatedProvidesCapabilities + ",";
                }
            }
        }
        return updatedProvidesCapabilities;
    }
}

